/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.LngCallable;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.BlockCommand;
import ch.turic.commands.BreakCommand;
import ch.turic.commands.ClosureOrMacro;
import ch.turic.commands.Conditional;
import ch.turic.commands.FunctionCall;
import ch.turic.commands.Identifier;
import ch.turic.commands.ParameterList;
import ch.turic.memory.HasFields;
import ch.turic.memory.LngObject;
import ch.turic.memory.Variable;
import ch.turic.utils.NullableOptional;
import ch.turic.utils.Unmarshaller;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.SequencedMap;

public final class Closure
extends AbstractCommand
implements ClosureOrMacro,
LngCallable.LngCallableClosure {
    final String name;
    final ParameterList parameters;
    final ch.turic.memory.Context wrapped;
    final String[] returnType;
    final BlockCommand command;

    public Closure(String name, ParameterList parameters, ch.turic.memory.Context wrapped, String[] returnType, BlockCommand command) {
        this.name = name;
        this.parameters = parameters;
        this.wrapped = wrapped;
        this.returnType = returnType;
        this.command = command;
    }

    public static Closure factory(Unmarshaller.Args args) {
        return new Closure(args.str("name"), args.get("parameters", ParameterList.class), args.get("wrapped", ch.turic.memory.Context.class), args.get("returnType", String[].class), args.get("command", BlockCommand.class));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ParameterList parameters() {
        return this.parameters;
    }

    @Override
    public ch.turic.memory.Context wrapped() {
        return this.wrapped;
    }

    public BlockCommand command() {
        return this.command;
    }

    public String[] returnType() {
        return this.returnType;
    }

    @Override
    public Object _execute(ch.turic.memory.Context ctx) throws ExecutionException {
        ctx.step();
        Object result = null;
        for (Command command : this.command.commands()) {
            Conditional.ReturnResult returnResult;
            ExecutionException.when(command instanceof BreakCommand, "You cannot break from a function or closure. Use Return", new Object[0]);
            result = command.execute(ctx);
            if (!(result instanceof Conditional.ReturnResult) || !(returnResult = (Conditional.ReturnResult)result).isDone()) continue;
            return returnResult.result();
        }
        if (Closure.isOfTypes(ctx, result, this.returnType)) {
            return result;
        }
        throw new ExecutionException("Cannot return from '%s' the value '%s' as it does not fit any of the accepted type of the function/closure (%s)", this.name, result, String.join((CharSequence)",", this.returnType));
    }

    public static boolean isOfTypes(ch.turic.memory.Context ctx, Object value, String[] types) {
        if (types == null || types.length == 0) {
            return true;
        }
        for (String typeName : types) {
            Variable.Type type = Variable.getTypeFromName(ctx, typeName);
            if (!Variable.isFit(value, type.javaType(), type.lngClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object call(Context callerContext, Object ... arguments) {
        if (!(callerContext instanceof ch.turic.memory.Context)) {
            throw new RuntimeException("Cannot work with this context implementation. This is an internal error.");
        }
        ch.turic.memory.Context context = (ch.turic.memory.Context)callerContext;
        ch.turic.memory.Context ctx = context.wrap(this.wrapped);
        FunctionCall.defineArgumentsInContext(ctx, context, this.parameters, (FunctionCall.ArgumentEvaluated[])Arrays.stream(arguments).map(param -> new FunctionCall.ArgumentEvaluated(null, param)).toArray(FunctionCall.ArgumentEvaluated[]::new), true);
        return this.execute(ctx);
    }

    public Object callAsMethod(ch.turic.memory.Context context, LngObject obj, String methodName, Object ... params) {
        FunctionCall.ArgumentEvaluated[] argValues = new FunctionCall.ArgumentEvaluated[params.length];
        for (int i = 0; i < params.length; ++i) {
            argValues[i] = new FunctionCall.ArgumentEvaluated(null, params[i]);
        }
        NullableOptional<Object> res = ClosureOrMacro.callTheMethod(context, obj, methodName, argValues, this);
        if (res.isPresent()) {
            return res.get();
        }
        throw new ExecutionException("Calling method %s is not possible on object %s", methodName, obj);
    }

    public Object callAsMethod(ch.turic.memory.Context context, LngObject obj, String methodName, SequencedMap<String, Object> params) {
        FunctionCall.ArgumentEvaluated[] argValues = new FunctionCall.ArgumentEvaluated[params.size()];
        Iterator iterator = params.entrySet().iterator();
        for (int i = 0; i < params.size(); ++i) {
            Map.Entry entry = iterator.next();
            argValues[i] = new FunctionCall.ArgumentEvaluated(new Identifier((String)entry.getKey()), entry.getValue());
        }
        NullableOptional<Object> res = ClosureOrMacro.callTheMethod(context, obj, methodName, argValues, this);
        if (res.isPresent()) {
            return res.get();
        }
        throw new ExecutionException("Calling method %s is not possible on object %s", methodName, obj);
    }

    @Override
    public NullableOptional<Object> methodCall(ch.turic.memory.Context context, HasFields obj, String methodName, FunctionCall.Argument[] arguments) {
        FunctionCall.ArgumentEvaluated[] argValues = this.evaluateArguments(context, arguments);
        return ClosureOrMacro.callTheMethod(context, obj, methodName, argValues, this);
    }

    @Override
    public FunctionCall.ArgumentEvaluated[] evaluateArguments(ch.turic.memory.Context context, FunctionCall.Argument[] arguments) {
        return Closure.evaluateClosureArguments(context, arguments);
    }

    public static FunctionCall.ArgumentEvaluated[] evaluateClosureArguments(ch.turic.memory.Context context, FunctionCall.Argument[] arguments) {
        FunctionCall.ArgumentEvaluated[] argValues = arguments == null ? new FunctionCall.ArgumentEvaluated[]{} : new FunctionCall.ArgumentEvaluated[arguments.length];
        for (int i = 0; i < argValues.length; ++i) {
            argValues[i] = new FunctionCall.ArgumentEvaluated(arguments[i].id(), arguments[i].expression().execute(context));
        }
        return argValues;
    }
}

