/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.JavaObject;
import ch.turic.memory.LeftValue;
import ch.turic.memory.LngObject;
import ch.turic.utils.Unmarshaller;

public class FieldAccess
extends AbstractCommand {
    final Command object;
    final String identifier;
    final boolean lenient;

    public String identifier() {
        return this.identifier;
    }

    public Command object() {
        return this.object;
    }

    public static FieldAccess factory(Unmarshaller.Args args) {
        return new FieldAccess(args.command("object"), args.str("identifier"), args.bool("lenient"));
    }

    public FieldAccess(Command object, String identifier, boolean lenient) {
        this.identifier = identifier;
        this.object = object;
        this.lenient = lenient;
    }

    @Override
    public Object _execute(Context context) throws ExecutionException {
        HasFields object;
        Object rawObject = this.object.execute(context);
        if (rawObject == null) {
            ExecutionException.when(!this.lenient, "Cannot access the field '%s' because the object it is used on is undefined.", this.identifier);
            object = LngObject.newEmpty(context);
        } else {
            object = LeftValue.toObject(rawObject);
        }
        if (object instanceof JavaObject) {
            JavaObject jo = (JavaObject)object;
            return jo.getField(this.identifier, context);
        }
        return object.getField(this.identifier);
    }
}

