/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands.operators;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.operators.AbstractOperator;
import ch.turic.commands.operators.Cast;
import ch.turic.commands.operators.Operator;
import ch.turic.commands.operators.Reflect;
import ch.turic.memory.Context;
import ch.turic.memory.InfiniteValue;
import ch.turic.memory.LngList;
import java.util.regex.Pattern;

@Operator.Symbol(value="-")
public class Subtract
extends AbstractOperator {
    @Override
    public Object unaryOp(Context ctx, Object op) throws ExecutionException {
        if (Cast.isLong(op)) {
            return -Cast.toLong(op).longValue();
        }
        if (Cast.isDouble(op)) {
            return -Cast.toDouble(op).doubleValue();
        }
        if (op instanceof InfiniteValue) {
            InfiniteValue iv = (InfiniteValue)op;
            return iv.negate();
        }
        return Reflect.getUnaryMethod("negate", op).map(Reflect.Op::callMethod).orElseThrow(() -> new ExecutionException("Cannot %s.negate()", op));
    }

    @Override
    public Object binaryOp(Context ctx, Object op1, Command right) throws ExecutionException {
        Object op2 = right.execute(ctx);
        if (op1 instanceof CharSequence) {
            CharSequence s = (CharSequence)op1;
            return s.toString().replaceAll(Pattern.quote(op2.toString()), "");
        }
        if (op1 instanceof LngList) {
            LngList list1 = (LngList)op1;
            LngList diff = new LngList();
            diff.array.addAll(list1.array);
            if (op2 instanceof LngList) {
                LngList list2 = (LngList)op2;
                diff.array.removeAll(list2.array);
            } else {
                diff.array.remove(op2);
            }
            return diff;
        }
        return this.binary("subtract", op1, op2, (a, b) -> a - b, (a, b) -> a - b);
    }
}

