/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.memory.Context;
import ch.turic.memory.LngClass;
import ch.turic.memory.Variable;
import java.util.ArrayList;
import java.util.List;

public class ClassContext
extends Context {
    private final LngClass[] parents;

    public ClassContext(Context context, LngClass[] parents) {
        super(context.globalContext, context.threadContext);
        this.parents = parents;
    }

    @Override
    public Object get(String key) {
        Object value = super.getLocal(key);
        if (value != null) {
            return value;
        }
        for (LngClass parent : this.parents) {
            Object inherited = parent.context().get(key);
            if (inherited == null) continue;
            return inherited;
        }
        Variable variable = this.globalContext.heap.get(key);
        if (variable != null) {
            return variable.get();
        }
        return null;
    }

    @Override
    public List<Context> wrappingContexts() {
        ArrayList<Context> ctxList = new ArrayList<Context>(super.wrappingContexts());
        for (LngClass parent : this.parents) {
            ctxList.addAll(parent.context().wrappingContexts());
        }
        return ctxList;
    }

    @Override
    public boolean contains(String key) {
        boolean thisContains = super.contains(key);
        if (thisContains) {
            return true;
        }
        for (LngClass parent : this.parents) {
            if (!parent.context().contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsLocal(String key) {
        if (super.containsLocal(key)) {
            return true;
        }
        for (LngClass parent : this.parents) {
            if (!parent.context().containsLocal(key)) continue;
            return true;
        }
        return false;
    }

    public LngClass[] parents() {
        return this.parents;
    }
}

