/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.commands.Closure;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.CompositionModifier;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.LngList;
import ch.turic.memory.LngObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;

public interface HasIndex
extends Iterable<Object> {
    public void setIndex(Object var1, Object var2) throws ExecutionException;

    public Object getIndex(Object var1) throws ExecutionException;

    public static HasIndex createFor(Object indexValue, Context ctx) {
        HasFields newIndexable = Cast.isLong(indexValue) ? new LngList() : LngObject.newEmpty(ctx);
        return newIndexable;
    }

    public static void filterElements(long start, long end, CompositionModifier[] modifiers, Context context, LngList list, Function<Long, Object> fetch) throws ExecutionException {
        long i = start;
        while (!Objects.equals(i, end)) {
            boolean filtered = false;
            Object item = fetch.apply(i);
            if (modifiers != null) {
                for (CompositionModifier modifier : modifiers) {
                    CompositionModifier compositionModifier;
                    Objects.requireNonNull(modifier);
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompositionModifier.Filter.class, CompositionModifier.Mapper.class}, (Object)compositionModifier, n)) {
                        case 0: {
                            CompositionModifier.Filter f = (CompositionModifier.Filter)compositionModifier;
                            context.local("it", item);
                            Object expression = f.expression.execute(context);
                            if (expression instanceof Closure) {
                                Closure closure = (Closure)expression;
                                ExecutionException.when(!closure.parameters().fitModifier(), "Filter closure or function must have exactly one parameter", new Object[0]);
                                Context ctx = context.wrap(context);
                                HasIndex.setParameter(ctx, closure, item);
                                filtered = !Cast.toBoolean(closure.execute(ctx));
                                break;
                            }
                            filtered = !Cast.toBoolean(expression);
                            break;
                        }
                        case 1: {
                            CompositionModifier.Mapper m = (CompositionModifier.Mapper)compositionModifier;
                            context.local("it", item);
                            Object expression = m.expression.execute(context);
                            if (expression instanceof Closure) {
                                Closure closure = (Closure)expression;
                                ExecutionException.when(!closure.parameters().fitModifier(), "Modifier closure or function must have exactly one parameter", new Object[0]);
                                Context ctx = context.wrap(context);
                                HasIndex.setParameter(ctx, closure, item);
                                item = closure.execute(ctx);
                                break;
                            }
                            item = expression;
                            break;
                        }
                        default: {
                            throw new RuntimeException("unknown modifier types, this is an internal error " + String.valueOf(modifier.getClass()));
                        }
                    }
                    if (filtered) break;
                }
                if (!filtered) {
                    list.array.add(item);
                }
            } else {
                list.array.add(i);
            }
            i += i <= end ? 1L : -1L;
        }
    }

    private static void setParameter(Context ctx, Closure closure, Object item) {
        if (closure.parameters().parameters().length > 0) {
            ctx.local(closure.parameters().parameters()[0].identifier(), item);
        }
    }
}

