/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.utils;

import ch.turic.ExecutionException;
import ch.turic.utils.StringUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Glob {
    public static List<String> glob(String pattern, boolean recurse) throws IOException {
        DirNPath dirNPath = Glob.splitToDirAndPattern(pattern);
        Path root = Path.of(dirNPath.baseDir(), new String[0]);
        if (recurse) {
            return Glob.globRecursive(dirNPath.matcher(), root, Integer.MAX_VALUE);
        }
        return Glob.globRecursive(dirNPath.matcher(), root, 1);
    }

    private static DirNPath splitToDirAndPattern(String pattern) {
        Matcher matcher;
        String baseDir;
        if (pattern.contains("/")) {
            int lastSlash = Glob.getLastSlashBeforeWildCard(pattern);
            if (lastSlash == -1) {
                baseDir = Path.of(".", new String[0]).normalize().toAbsolutePath().toString();
                matcher = new Matcher(pattern, baseDir);
            } else {
                baseDir = Path.of(pattern.substring(0, lastSlash), new String[0]).normalize().toAbsolutePath().toString();
                pattern = pattern.substring(lastSlash + 1);
                matcher = new Matcher(pattern, baseDir);
            }
        } else {
            baseDir = Path.of(".", new String[0]).normalize().toAbsolutePath().toString();
            matcher = new Matcher(pattern, baseDir);
        }
        return new DirNPath(baseDir, matcher);
    }

    private static int getLastSlashBeforeWildCard(String pattern) {
        int star = pattern.indexOf("*");
        int qm = pattern.indexOf("?");
        int firstWildcard = qm == -1 ? star : (star == -1 ? qm : Math.min(star, qm));
        if (firstWildcard == -1) {
            return pattern.lastIndexOf(47);
        }
        return pattern.substring(0, firstWildcard).lastIndexOf(47);
    }

    public static List<String> globRecursive(Predicate<String> matcher, Path root, int depth) throws IOException {
        String baseDir = root.normalize().toAbsolutePath().toString();
        try (Stream<Path> stream = Files.walk(root, depth, new FileVisitOption[0]);){
            List<String> list = stream.map(path -> path.normalize().toAbsolutePath().toString()).filter(matcher).map(s -> Files.isRegularFile(Path.of(s, new String[0]), new LinkOption[0]) ? s : s + "/").filter(s -> !s.equals(baseDir)).map(s -> s.substring(baseDir.length() + 1)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            return list;
        }
    }

    private record DirNPath(String baseDir, Predicate<String> matcher) {
    }

    public static class Matcher
    implements Predicate<String> {
        final String pattern;
        final String baseDir;

        public Matcher(String pattern, String baseDir) {
            this.pattern = pattern;
            this.baseDir = baseDir;
        }

        @Override
        public boolean test(String s) {
            String relative;
            if (s.startsWith(this.baseDir + "/")) {
                relative = s.substring(this.baseDir.length() + 1);
            } else if (s.startsWith(this.baseDir)) {
                relative = "";
            } else {
                throw new ExecutionException("Invalid test path : '" + s + "' for base dir '" + this.baseDir + "'", new Object[0]);
            }
            return StringUtils.matches(this.pattern, relative);
        }
    }
}

