/*
 * Decompiled with CFR 0.152.
 */
package ch.turic;

import ch.turic.BadSyntax;
import ch.turic.BuiltIns;
import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.Input;
import ch.turic.Program;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.Lexer;
import ch.turic.analyzer.ProgramAnalyzer;
import ch.turic.memory.Context;
import ch.turic.memory.LngStackFrame;
import ch.turic.utils.Marshaller;
import ch.turic.utils.Unmarshaller;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class Interpreter {
    private ch.turic.analyzer.Input source = null;
    private volatile Program code = null;
    private final Object lock = new Object();
    private Context preprocessorContext;
    private Context ctx;

    public Interpreter(String source) {
        this.source = (ch.turic.analyzer.Input)Input.fromString(source);
    }

    public Interpreter(Input source) {
        this.source = (ch.turic.analyzer.Input)source;
    }

    public Interpreter(Program code) {
        this.code = code;
    }

    public Interpreter(Path file) throws IOException {
        String fn = file.toFile().getAbsolutePath();
        if (fn.endsWith(".turi")) {
            String s = Files.readString(file, StandardCharsets.UTF_8);
            this.source = new ch.turic.analyzer.Input(new StringBuilder(s), fn);
        } else if (fn.endsWith(".turc")) {
            byte[] bytes = Files.readAllBytes(file);
            Unmarshaller unmarshaller = new Unmarshaller();
            this.code = unmarshaller.deserialize(bytes);
            this.ctx = new Context();
            BuiltIns.register(this.ctx);
        } else {
            throw new RuntimeException("Unsupported file type");
        }
    }

    public ch.turic.Context getImportContext() {
        return this.ctx;
    }

    public Object compileAndExecute() throws BadSyntax, ExecutionException {
        Program localCode = this.compile();
        return this.execute(localCode);
    }

    public Object execute(Command code) {
        try {
            return code.execute(this.ctx);
        }
        catch (ExecutionException e) {
            ArrayList<StackTraceElement> newStackTrace = new ArrayList<StackTraceElement>();
            List<LngStackFrame> stackTrace = this.ctx.threadContext.getStackTrace();
            for (int i = stackTrace.size() - 1; i >= 0; --i) {
                LngStackFrame stackFrame = stackTrace.get(i);
                if (stackFrame.command().startPosition() == null) continue;
                newStackTrace.add(new StackTraceElement(stackFrame.command().getClass().getSimpleName(), "", stackFrame.command().startPosition().file, stackFrame.command().startPosition().line));
            }
            ExecutionException turiException = new ExecutionException(e);
            turiException.setStackTrace((StackTraceElement[])newStackTrace.toArray(StackTraceElement[]::new));
            throw turiException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Program compile() {
        Command localCode = this.code;
        if (localCode == null) {
            Object object = this.lock;
            synchronized (object) {
                localCode = this.code;
                if (localCode == null) {
                    ProgramAnalyzer analyzer = new ProgramAnalyzer();
                    LexList lexes = Lexer.analyze(this.source);
                    localCode = lexes.isEmpty() ? new Program(new Command[0]) : analyzer.analyze(lexes);
                    this.code = localCode;
                    this.preprocessorContext = analyzer.context();
                }
            }
        }
        this.ctx = new Context();
        BuiltIns.register(this.ctx);
        return localCode;
    }

    public byte[] serialize() {
        Marshaller marshaller = new Marshaller();
        return marshaller.serialize(this.code);
    }
}

