/*
 * Decompiled with CFR 0.152.
 */
package ch.turic;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public interface ServiceLoaded {
    public static <T> List<T> getInstances(Class<T> service) {
        List<T> services = ServiceLoaded.getInstances(service, Thread.currentThread().getContextClassLoader());
        if (!services.isEmpty()) {
            return services;
        }
        return ServiceLoaded.getInstances(service, ServiceLoaded.class.getClassLoader());
    }

    public static <T> List<T> getInstances(Class<T> service, ClassLoader cl) {
        ArrayList list = new ArrayList();
        try {
            ServiceLoader<T> services = ServiceLoader.load(service, cl);
            services.iterator().forEachRemaining(list::add);
            if (list.isEmpty()) {
                ServiceLoaded.loadViaMetaInf(service, list, cl);
            }
            return list;
        }
        catch (ServiceConfigurationError ignored) {
            ServiceLoaded.loadViaMetaInf(service, list, cl);
            return list;
        }
    }

    public static <T> void loadViaMetaInf(Class<T> klass, List<T> list, ClassLoader cl) {
        try {
            HashSet classes = new HashSet();
            for (URL url : ServiceLoaded.loadResources("META-INF/services/" + klass.getName(), cl)) {
                InputStream is = url.openStream();
                try {
                    for (String className : new String(is.readAllBytes(), StandardCharsets.UTF_8).split("[\n\r]+")) {
                        try {
                            Class<?> providerKlass = Class.forName(className);
                            if (classes.contains(providerKlass)) continue;
                            classes.add(providerKlass);
                            Method providerMethod = ServiceLoaded.getProvider(providerKlass);
                            Object instance = providerMethod == null ? providerKlass.getConstructor(new Class[0]).newInstance(new Object[0]) : providerMethod.invoke(null, new Object[0]);
                            list.add(instance);
                        }
                        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static <T> Method getProvider(Class<T> klass) {
        try {
            return klass.getDeclaredMethod("provider", new Class[0]);
        }
        catch (NoClassDefFoundError | NoSuchMethodException e) {
            return null;
        }
    }

    public static List<URL> loadResources(String name, ClassLoader classLoader) throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        Enumeration<URL> systemResources = (classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader).getResources(name);
        while (systemResources.hasMoreElements()) {
            list.add(systemResources.nextElement());
        }
        return list;
    }
}

