/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.BlockAnalyzer;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.ParameterDefinition;
import ch.turic.commands.BlockCommand;
import ch.turic.commands.ClosureDefinition;
import ch.turic.commands.ParameterList;
import java.util.ArrayList;

public class ClosureAnalyzer
extends AbstractAnalyzer {
    public static final ClosureAnalyzer INSTANCE = new ClosureAnalyzer();

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        ParameterList identifiers;
        Lex opening = lexes.next();
        if (opening.is("|")) {
            identifiers = ParameterDefinition.FOR_CLOSURE.analyze(lexes);
            lexes.peek(Lex.Type.RESERVED, "|", "Closure arguments but be between two '|' characters");
            lexes.next();
        } else {
            identifiers = ParameterList.EMPTY;
        }
        ArrayList<Command> commands = BlockAnalyzer.INSTANCE.getCommands(lexes);
        BlockCommand block = new BlockCommand((Command[])commands.toArray(Command[]::new), true);
        return new ClosureDefinition(identifiers, block);
    }

    public static boolean blockStartsClosure(LexList lexes) {
        return lexes.isAt(1, "|", "||");
    }
}

