/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.CommandAnalyzer;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.Pos;
import ch.turic.commands.FlowCommand;
import java.util.ArrayList;

public class FlowAnalyzer
extends AbstractAnalyzer {
    public static final FlowAnalyzer INSTANCE = new FlowAnalyzer();
    private static final String LIMIT = "limit";
    private static final String TIMEOUT = "timeout";

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        Pos flowStartPos = lexes.position();
        Command exitCondition = null;
        Command limitExpression = null;
        Command timeoutExpression = null;
        ArrayList<String> cellIds = new ArrayList<String>();
        ArrayList<Command> cells = new ArrayList<Command>();
        String flowId = lexes.isIdentifier() && !lexes.isIdentifier(LIMIT, TIMEOUT) ? lexes.next().text : null;
        while (lexes.isNot("{")) {
            if (lexes.is("until")) {
                if (exitCondition != null) {
                    throw lexes.syntaxError("There can only be one exit condition in flow.", new Object[0]);
                }
                lexes.next();
                exitCondition = CommandAnalyzer.INSTANCE.analyze(lexes);
                if (lexes.is(";")) {
                    lexes.next();
                }
            }
            if (lexes.isIdentifier(LIMIT)) {
                if (limitExpression != null) {
                    throw lexes.syntaxError("There can only be one limit in flow.", new Object[0]);
                }
                lexes.next();
                limitExpression = CommandAnalyzer.INSTANCE.analyze(lexes);
                if (lexes.is(";")) {
                    lexes.next();
                }
            }
            if (!lexes.isIdentifier(TIMEOUT)) continue;
            if (timeoutExpression != null) {
                throw lexes.syntaxError("There can only be one timeout in flow.", new Object[0]);
            }
            lexes.next();
            timeoutExpression = CommandAnalyzer.INSTANCE.analyze(lexes);
        }
        Command resultExpression = null;
        if (lexes.is("{")) {
            lexes.next();
            while (lexes.isNot("}")) {
                if (lexes.is("yield")) {
                    lexes.next();
                    resultExpression = CommandAnalyzer.INSTANCE.analyze(lexes);
                    break;
                }
                if (lexes.isIdentifier()) {
                    String cellIdentifier = lexes.next().text();
                    if (lexes.is("<-")) {
                        lexes.next();
                        Command cellCommand = CommandAnalyzer.INSTANCE.analyze(lexes);
                        cellIds.add(cellIdentifier);
                        cells.add(cellCommand);
                        continue;
                    }
                    throw lexes.syntaxError("in flow 'x <- expression' statements are expected", new Object[0]);
                }
                throw lexes.syntaxError("Expected identifier or yield in 'flow' command", new Object[0]);
            }
            if (lexes.isNot("}")) {
                throw lexes.syntaxError("Flow command closing '}' is missing", new Object[0]);
            }
            lexes.next();
            try {
                return new FlowCommand(flowId, exitCondition, limitExpression, timeoutExpression, resultExpression, (String[])cellIds.toArray(String[]::new), (Command[])cells.toArray(Command[]::new));
            }
            catch (ExecutionException e) {
                BadSyntax bs = new BadSyntax(flowStartPos, e.getMessage(), new Object[0]);
                bs.setStackTrace(e.getStackTrace());
                throw bs;
            }
        }
        if (lexes.is(":")) {
            throw lexes.syntaxError("The flow command does not allow ': command' ", new Object[0]);
        }
        throw lexes.syntaxError("in flow 'x expression' statements are expected", new Object[0]);
    }
}

