/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.ForLoopAnalyzer;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.commands.ForEachLoop;
import ch.turic.commands.Identifier;

public class ForEachLoopAnalyzer
extends AbstractAnalyzer {
    public static final ForEachLoopAnalyzer INSTANCE = new ForEachLoopAnalyzer();

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        boolean resultList;
        Identifier with;
        boolean withParentheses = lexes.is("(");
        if (withParentheses) {
            lexes.next();
        }
        lexes.peek(Lex.Type.IDENTIFIER, null, "'for each' needs an identifier");
        String name = lexes.next().text();
        Identifier identifier = new Identifier(name);
        if (lexes.is("with")) {
            lexes.next();
            lexes.peek(Lex.Type.IDENTIFIER, null, "'for each... with' needs an identifier");
            with = new Identifier(lexes.next().text());
        } else {
            with = null;
        }
        if (lexes.is("in")) {
            lexes.next();
        }
        Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
        ForLoopAnalyzer.checkClosingParen(lexes, withParentheses);
        if (lexes.is("list")) {
            resultList = true;
            lexes.next();
        } else {
            resultList = false;
        }
        Command body = ForLoopAnalyzer.getLoopBody(lexes);
        Command exitCondition = ForLoopAnalyzer.getOptionalExistCondition(lexes);
        return new ForEachLoop(identifier, with, expression, resultList, body, exitCondition);
    }
}

