/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.BuiltIns;
import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.Input;
import ch.turic.Program;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.CommandAnalyzer;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.Lexer;
import ch.turic.commands.Closure;
import ch.turic.memory.Context;
import java.util.ArrayList;

public class ProgramAnalyzer
extends AbstractAnalyzer {
    private Context preprocessorContext = null;

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        ArrayList<Command> commands = new ArrayList<Command>();
        while (lexes.hasNext()) {
            Command cmd;
            if (lexes.is("#")) {
                lexes.next();
                Command preprocessor = CommandAnalyzer.INSTANCE.analyze(lexes);
                if (this.preprocessorContext == null) {
                    this.preprocessorContext = new Context();
                    BuiltIns.register(this.preprocessorContext);
                }
                this.preprocess(lexes, preprocessor, commands);
            }
            if ((cmd = CommandAnalyzer.INSTANCE.analyze(lexes)) == null) continue;
            commands.add(cmd);
        }
        return new Program((Command[])commands.toArray(Command[]::new));
    }

    public Context context() {
        return this.preprocessorContext;
    }

    private void preprocess(LexList lexes, Command preprocessor, ArrayList<Command> commands) {
        lexes.purge();
        new Program((Command[])commands.toArray(Command[]::new)).execute(this.preprocessorContext);
        Object preprocClosure = preprocessor.execute(this.preprocessorContext);
        if (preprocClosure instanceof Closure) {
            Closure closure = (Closure)preprocClosure;
            Object newLexes = closure.call(this.preprocessorContext, lexes);
            lexes.array.clear();
            if (!(newLexes instanceof Iterable)) {
                throw new ExecutionException("Preprocessor returned '%s', not usable", newLexes);
            }
            Iterable lngListLexes = (Iterable)newLexes;
            lngListLexes.forEach(item -> {
                if (item instanceof Lex) {
                    Lex lex = (Lex)item;
                    lexes.array.add(lex);
                } else {
                    lexes.array.addAll(Lexer.analyze((ch.turic.analyzer.Input)((ch.turic.analyzer.Input)Input.fromString((String)item.toString()))).array);
                }
            });
        } else {
            throw new ExecutionException("Preprocessor is not executable", new Object[0]);
        }
        commands.clear();
    }
}

