/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.classes;

import ch.turic.ExecutionException;
import ch.turic.LngCallable;
import ch.turic.TuriClass;
import ch.turic.builtins.classes.TuriMethod;
import java.io.InputStreamReader;

public class TuriInputStreamReader
implements TuriClass {
    @Override
    public Class<?> forClass() {
        return InputStreamReader.class;
    }

    @Override
    public LngCallable getMethod(Object target, String identifier) throws ExecutionException {
        if (!(target instanceof InputStreamReader)) {
            throw new ExecutionException("Target object is not an InputStream, this is an internal error", new Object[0]);
        }
        InputStreamReader isr = (InputStreamReader)target;
        return switch (identifier) {
            case "read_char" -> new TuriMethod<String>(args -> {
                int ch = isr.read();
                if (ch == -1) {
                    return null;
                }
                return new String(Character.toChars(ch));
            });
            case "close" -> new TuriMethod<Object>(args -> {
                isr.close();
                return null;
            });
            default -> throw new ExecutionException("Invalid method '" + identifier + "' for input stream.", new Object[0]);
        };
    }
}

