/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

public sealed interface Conditional {
    public boolean isDone();

    public Object result();

    public static Conditional doReturn(Object result) {
        return new ReturnResult(result, true);
    }

    public static Conditional doBreak(Object result) {
        return new BreakResult(result, true);
    }

    public static Conditional result(Object result) {
        return new Result(result, false);
    }

    public static final class ReturnResult
    extends Result {
        private ReturnResult(Object result, boolean done) {
            super(result, done);
        }

        @Override
        public String toString() {
            return "return{" + String.valueOf(this.result()) + "}";
        }
    }

    public static final class BreakResult
    extends Result {
        private BreakResult(Object result, boolean done) {
            super(result, done);
        }

        @Override
        public String toString() {
            return "break{" + String.valueOf(this.result()) + "}";
        }
    }

    public static sealed class Result
    implements Conditional
    permits BreakResult, ReturnResult {
        private final Object result;
        private final boolean done;

        private Result(Object result, boolean done) {
            this.result = result;
            this.done = done;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Object result() {
            return this.result;
        }

        public String toString() {
            return "result{" + String.valueOf(this.result()) + "}";
        }
    }
}

