/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands.operators;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.operators.AbstractOperator;
import ch.turic.commands.operators.Operator;
import ch.turic.memory.Context;

@Operator.Symbol(value="**")
public class Pow
extends AbstractOperator {
    @Override
    public Object binaryOp(Context ctx, Object op1, Command right) throws ExecutionException {
        Object op2 = right.execute(ctx);
        return this.binary("pow", op1, op2, Pow::pow, Math::pow);
    }

    private static long pow(long a, long b) {
        if (b < 0L) {
            throw new ExecutionException("Negative exponents not supported for integers", new Object[0]);
        }
        if (b == 0L) {
            return 1L;
        }
        if (b == 1L) {
            return a;
        }
        long result = 1L;
        long base = a;
        for (long exponent = b; exponent > 0L; exponent >>= 1) {
            if ((exponent & 1L) == 1L) {
                result *= base;
            }
            base *= base;
        }
        return result;
    }
}

