/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.memory.CalculatedLeftValue;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.HasIndex;
import ch.turic.memory.IndexedString;
import ch.turic.memory.LeftValue;
import ch.turic.memory.LngObject;
import ch.turic.memory.ObjectFieldLeftValue;
import ch.turic.memory.VariableLeftValue;
import ch.turic.utils.Unmarshaller;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;

public record ArrayElementLeftValue(LeftValue arrayLeftValue, Command index) implements LeftValue
{
    public ArrayElementLeftValue {
        Objects.requireNonNull(index);
    }

    public static ArrayElementLeftValue factory(Unmarshaller.Args args) {
        return new ArrayElementLeftValue(args.get("arrayLeftValue", LeftValue.class), args.command("index"));
    }

    @Override
    public HasFields getObject(Context ctx) {
        Object indexValue = this.index.execute(ctx);
        HasIndex guaranteedObject = this.arrayLeftValue.getIndexable(ctx, indexValue);
        Object existing = guaranteedObject.getIndex(indexValue);
        if (existing == null) {
            LngObject newObject = LngObject.newEmpty(ctx);
            guaranteedObject.setIndex(indexValue, newObject);
            return newObject;
        }
        return LeftValue.toObject(existing);
    }

    @Override
    public HasIndex getIndexable(Context ctx, Object indexValue) {
        Object leftValueIndex = this.index.execute(ctx);
        HasIndex guaranteedObject = this.arrayLeftValue.getIndexable(ctx, leftValueIndex);
        Object existing = guaranteedObject.getIndex(leftValueIndex);
        if (existing == null) {
            HasIndex newIndexable = HasIndex.createFor(indexValue, ctx);
            guaranteedObject.setIndex(leftValueIndex, newIndexable);
            return new WithIndexedContainer(newIndexable, guaranteedObject, leftValueIndex);
        }
        return new WithIndexedContainer(LeftValue.toIndexable(existing), guaranteedObject, leftValueIndex);
    }

    @Override
    public void assign(Context ctx, Object value) throws ExecutionException {
        Object indexValue = this.index.execute(ctx);
        HasIndex indexable = this.arrayLeftValue.getIndexable(ctx, indexValue);
        indexable.setIndex(indexValue, value);
        this.updateString(ctx, indexable);
    }

    @Override
    public Object reassign(Context ctx, Function<Object, Object> newValueCalculator) throws ExecutionException {
        Object newValue;
        Object value;
        Object indexValue = this.index.execute(ctx);
        HasIndex indexable = this.arrayLeftValue.getIndexable(ctx, indexValue);
        try (Context.VariableHibernation vh = this.getVariableHibernation(ctx);){
            value = indexable.getIndex(indexValue);
            newValue = newValueCalculator.apply(value);
        }
        Object checkValue = indexable.getIndex(indexValue);
        this.assertNoChange(value, checkValue);
        indexable.setIndex(indexValue, newValue);
        this.updateString(ctx, indexable);
        return newValue;
    }

    private Context.VariableHibernation getVariableHibernation(Context ctx) {
        LeftValue leftValue = this.arrayLeftValue;
        Objects.requireNonNull(leftValue);
        LeftValue leftValue2 = leftValue;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CalculatedLeftValue.class, VariableLeftValue.class, ObjectFieldLeftValue.class}, (Object)leftValue2, n)) {
            case 0 -> {
                CalculatedLeftValue ignored = (CalculatedLeftValue)leftValue2;
                throw new ExecutionException("Cannot change the part of a calculated string. Left side of the assignment has to be left value.", new Object[0]);
            }
            case 1 -> {
                VariableLeftValue leftValue = (VariableLeftValue)leftValue2;
                yield ctx.hibernate(leftValue.variable());
            }
            case 2 -> {
                ObjectFieldLeftValue leftValue = (ObjectFieldLeftValue)leftValue2;
                HasFields obj = leftValue.getObject(ctx);
                if (obj instanceof LngObject) {
                    LngObject lngObject = (LngObject)obj;
                    yield lngObject.context().hibernate(leftValue.field());
                }
                yield ctx.new Context.VariableHibernation();
            }
            default -> ctx.new Context.VariableHibernation();
        };
    }

    private void assertNoChange(Object value, Object checkValue) {
        if (!(value instanceof String) ? value != checkValue : !Objects.equals(value, checkValue)) {
            throw new ExecutionException("Assigned value changed while calculating new value %s", this);
        }
    }

    private void updateString(Context ctx, HasIndex indexable) {
        HasIndex embedded = indexable;
        while (embedded instanceof WithIndexedContainer) {
            WithIndexedContainer wic = (WithIndexedContainer)embedded;
            embedded = wic.indexed;
        }
        if (embedded instanceof IndexedString) {
            StringBuilder string;
            IndexedString indexedString = (IndexedString)embedded;
            try {
                StringBuilder stringBuilder;
                string = stringBuilder = indexedString.string();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (indexable instanceof WithIndexedContainer) {
                WithIndexedContainer withIndexedContainer = (WithIndexedContainer)indexable;
                withIndexedContainer.set(string.toString());
            } else {
                this.arrayLeftValue.assign(ctx, string.toString());
            }
        }
    }

    @Override
    public String toString() {
        return this.arrayLeftValue.toString() + "[" + this.index.toString() + "]";
    }

    public record WithIndexedContainer(HasIndex indexed, HasIndex container, Object lastIndex) implements HasIndex
    {
        public void set(Object value) {
            this.container.setIndex(this.lastIndex, value);
        }

        @Override
        public void setIndex(Object index, Object value) throws ExecutionException {
            this.indexed.setIndex(index, value);
        }

        @Override
        public Object getIndex(Object index) throws ExecutionException {
            return this.indexed.getIndex(index);
        }

        @Override
        public Iterator<Object> iterator() {
            return this.indexed.iterator();
        }
    }
}

