/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.HasIndex;
import ch.turic.memory.LeftValue;
import ch.turic.memory.LngObject;
import ch.turic.utils.Unmarshaller;
import java.util.Objects;
import java.util.function.Function;

public record ObjectFieldLeftValue(LeftValue object, String field) implements LeftValue
{
    public ObjectFieldLeftValue {
        Objects.requireNonNull(field);
    }

    public static ObjectFieldLeftValue factory(Unmarshaller.Args args) {
        return new ObjectFieldLeftValue(args.get("object", LeftValue.class), args.str("field"));
    }

    @Override
    public HasFields getObject(Context ctx) {
        HasFields guaranteedObject = this.object.getObject(ctx);
        Object existing = guaranteedObject.getField(this.field);
        if (existing == null) {
            LngObject newObject = LngObject.newEmpty(ctx);
            guaranteedObject.setField(this.field, newObject);
            return newObject;
        }
        return LeftValue.toObject(existing);
    }

    @Override
    public HasIndex getIndexable(Context ctx, Object indexValue) {
        HasFields guaranteedObject = this.object.getObject(ctx);
        Object existing = guaranteedObject.getField(this.field);
        if (existing == null) {
            HasIndex newIndexable = HasIndex.createFor(indexValue, ctx);
            guaranteedObject.setField(this.field, newIndexable);
            return newIndexable;
        }
        return LeftValue.toIndexable(existing);
    }

    @Override
    public void assign(Context ctx, Object value) throws ExecutionException {
        this.object.getObject(ctx).setField(this.field, value);
    }

    @Override
    public Object reassign(Context ctx, Function<Object, Object> newValueCalculator) throws ExecutionException {
        Object newValue;
        HasFields object = this.object.getObject(ctx);
        if (object instanceof LngObject) {
            LngObject lngObject = (LngObject)object;
            try (Context.VariableHibernation ignore = lngObject.context().hibernate(this.field);){
                Object value = lngObject.getField(this.field);
                newValue = newValueCalculator.apply(value);
            }
        } else {
            Object value = object.getField(this.field);
            newValue = newValueCalculator.apply(value);
            Object checkValue = object.getField(this.field);
            if (value != checkValue) {
                throw new ExecutionException("Assigned value changed while calculating new value %s.%s", this, this.field);
            }
        }
        object.setField(this.field, newValue);
        return newValue;
    }
}

