/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.AssignmentAnalyzer;
import ch.turic.analyzer.BlockAnalyzer;
import ch.turic.analyzer.BlockOrClosureAnalyzer;
import ch.turic.analyzer.ClassAnalyzer;
import ch.turic.analyzer.ClosureAnalyzer;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.FunctionDefinitionAnalyzer;
import ch.turic.analyzer.IfAnalyzer;
import ch.turic.analyzer.JsonStructureAnalyzer;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.commands.ArrayAccess;
import ch.turic.commands.EmptyObject;
import ch.turic.commands.FieldAccess;
import ch.turic.commands.FloatConstant;
import ch.turic.commands.FunctionCall;
import ch.turic.commands.Identifier;
import ch.turic.commands.IntegerConstant;
import ch.turic.commands.ListComposition;
import ch.turic.commands.StringConstant;
import ch.turic.commands.YieldFetch;
import ch.turic.memory.CompositionModifier;
import java.util.ArrayList;

public class PrimaryExpressionAnalyzer
extends AbstractAnalyzer {
    public static final PrimaryExpressionAnalyzer INSTANCE = new PrimaryExpressionAnalyzer();
    public static final Command[] EMPTY_COMMAND_ARRAY = new Command[0];

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        if (lexes.isEmpty()) {
            throw lexes.syntaxError("Expression is empty", new Object[0]);
        }
        if (lexes.is("yield")) {
            lexes.next();
            if (lexes.is("(")) {
                lexes.next();
                if (lexes.isNot(")")) {
                    throw lexes.syntaxError("Expected a closing parenthesis after 'yield'", new Object[0]);
                }
                lexes.next();
            }
            return new YieldFetch();
        }
        if (lexes.is("async")) {
            return ExpressionAnalyzer.INSTANCE.analyze(lexes);
        }
        if (lexes.is("class")) {
            lexes.next();
            return ClassAnalyzer.INSTANCE.analyze(lexes);
        }
        if (lexes.is("if")) {
            lexes.next();
            return IfAnalyzer.INSTANCE.analyze(lexes);
        }
        if (lexes.is("fn")) {
            lexes.next();
            return FunctionDefinitionAnalyzer.INSTANCE.analyze(lexes);
        }
        if (lexes.is("(")) {
            Command left = BlockAnalyzer.FLAT.analyze(lexes);
            return this.getAccessOrCall(lexes, left, false);
        }
        if (lexes.is("&{")) {
            return this.getAccessOrCall(lexes, JsonStructureAnalyzer.INSTANCE.analyze(lexes), false);
        }
        if (lexes.is("++", "--") && lexes.isAt(1, Lex.Type.IDENTIFIER) && !lexes.isAt(2, "[", ".", "(") || lexes.isIdentifier() && lexes.isAt(1, "++", "--")) {
            return AssignmentAnalyzer.INSTANCE.analyze(lexes);
        }
        if (lexes.is("{")) {
            if (lexes.isAt(1, "}")) {
                lexes.next();
                lexes.next();
                return this.getAccessOrCall(lexes, new EmptyObject(), false);
            }
            if ((lexes.isAt(1, Lex.Type.IDENTIFIER) || lexes.isAt(1, Lex.Type.STRING)) && lexes.isAt(2, ":")) {
                return this.getAccessOrCall(lexes, JsonStructureAnalyzer.INSTANCE.analyze(lexes), false);
            }
            return this.getAccessOrCall(lexes, BlockOrClosureAnalyzer.INSTANCE.analyze(lexes), false);
        }
        if (lexes.is("[")) {
            lexes.next();
            if (lexes.is("]")) {
                lexes.next();
                return this.getAccessOrCall(lexes, new ListComposition(EMPTY_COMMAND_ARRAY, null), false);
            }
            ArrayList<Command> expressionList = new ArrayList<Command>();
            while (true) {
                Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
                expressionList.add(expression);
                if (!lexes.is(",")) break;
                lexes.next();
            }
            if (!lexes.is("]", "?", "->", "with")) {
                throw lexes.syntaxError("Unexpected end of expression list in array literal", new Object[0]);
            }
            CompositionModifier[] modifiers = PrimaryExpressionAnalyzer.getModifierChain(lexes);
            ListComposition left = new ListComposition((Command[])expressionList.toArray(Command[]::new), modifiers);
            BadSyntax.when(lexes, lexes.isNot("]"), "list literal has to be closed using ']'", new Object[0]);
            lexes.next();
            return this.getAccessOrCall(lexes, left, false);
        }
        if (lexes.is("@")) {
            lexes.next();
            ExecutionException.when(!lexes.isIdentifier(), "@ has to be followed by a function name.", new Object[0]);
            Lex lex = lexes.next();
            return this.getAccessOrCall(lexes, new Identifier(lex.text()), true);
        }
        Lex lex = lexes.next();
        return switch (lex.type()) {
            case Lex.Type.IDENTIFIER -> this.getAccessOrCall(lexes, new Identifier(lex.text()), false);
            case Lex.Type.STRING -> this.getAccessOrCall(lexes, new StringConstant(lex.text(), lex.interpolated), false);
            case Lex.Type.INTEGER -> this.getAccessOrCall(lexes, new IntegerConstant(lex.text()), false);
            case Lex.Type.FLOAT -> this.getAccessOrCall(lexes, new FloatConstant(lex.text()), false);
            default -> throw lexes.syntaxError("Expression: expected identifier, or constant, got '%s'", lex.text());
        };
    }

    private static CompositionModifier[] getModifierChain(LexList lexes) throws BadSyntax {
        ArrayList<CompositionModifier.Mapper> modifiers = new ArrayList<CompositionModifier.Mapper>();
        boolean attached = false;
        while (lexes.is("?", "->", "with")) {
            if (attached) {
                throw lexes.syntaxError("No filers and modifiers are allowed after 'with'", new Object[0]);
            }
            String oper = lexes.next().text();
            Command modifierExpression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
            modifiers.add((CompositionModifier.Mapper)(switch (oper) {
                case "->" -> new CompositionModifier.Mapper(modifierExpression);
                case "?" -> new CompositionModifier.Filter(modifierExpression);
                case "with" -> {
                    attached = true;
                    yield new CompositionModifier.Attacher(modifierExpression);
                }
                default -> throw new RuntimeException("Unexpected operator: " + oper + "this is an internal error");
            }));
        }
        return (CompositionModifier[])modifiers.toArray(CompositionModifier[]::new);
    }

    private Command getAccessOrCall(LexList lexes, Command left, boolean isDecorator) throws BadSyntax {
        while (lexes.is("(", ".", "?.", "[")) {
            left = switch (lexes.next().text()) {
                case "(" -> new FunctionCall(left, PrimaryExpressionAnalyzer.analyzeArguments(lexes, isDecorator, true));
                case "." -> new FieldAccess(left, lexes.next(Lex.Type.IDENTIFIER).text(), false);
                case "?." -> new FieldAccess(left, lexes.next(Lex.Type.IDENTIFIER).text(), true);
                case "[" -> {
                    ArrayAccess indexExpression = new ArrayAccess(left, ExpressionAnalyzer.INSTANCE.analyze(lexes));
                    lexes.next(Lex.Type.RESERVED, "]", "Array indexing is not close with ]");
                    yield indexExpression;
                }
                default -> throw new IllegalStateException("Unexpected value: " + lexes.next().text());
            };
        }
        return left;
    }

    static FunctionCall.Argument[] analyzeArguments(LexList lexes, boolean isDecorator, boolean needsClosing) throws BadSyntax {
        ArrayList<FunctionCall.Argument> arguments = new ArrayList<FunctionCall.Argument>();
        while (lexes.isNot(")")) {
            if (lexes.isIdentifier() && lexes.isAt(1, "=")) {
                Identifier id = new Identifier(lexes.next().text());
                lexes.next();
                Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
                arguments.add(new FunctionCall.Argument(id, expression));
            } else {
                Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
                arguments.add(new FunctionCall.Argument(null, expression));
            }
            if (lexes.isNot(",")) break;
            lexes.next();
        }
        if (needsClosing) {
            BadSyntax.when(lexes, lexes.isNot(")"), "Function call: expected ')' after the parents", new Object[0]);
            lexes.next();
        }
        if (lexes.is("{") && ClosureAnalyzer.blockStartsClosure(lexes) && !lexes.peek().atLineStart()) {
            lexes.next();
            Command closure = ClosureAnalyzer.INSTANCE.analyze(lexes);
            arguments.add(new FunctionCall.Argument(null, closure));
        } else if (isDecorator) {
            if (lexes.is("fn")) {
                lexes.next();
                Command fn = FunctionDefinitionAnalyzer.INSTANCE.analyze(lexes);
                arguments.add(new FunctionCall.Argument(null, fn));
            } else if (lexes.is("class")) {
                lexes.next();
                Command klass = ClassAnalyzer.INSTANCE.analyze(lexes);
                arguments.add(new FunctionCall.Argument(null, klass));
            } else {
                throw lexes.syntaxError("Could not find what to decorate. Only closures, functions and classes can be decorated as for now.", new Object[0]);
            }
        }
        return (FunctionCall.Argument[])arguments.toArray(FunctionCall.Argument[]::new);
    }
}

