/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.BlockAnalyzer;
import ch.turic.analyzer.CommandAnalyzer;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.commands.WithCommand;
import ch.turic.utils.Unmarshaller;
import java.util.ArrayList;

public class WithAnalyzer
extends AbstractAnalyzer {
    public static final WithAnalyzer INSTANCE = new WithAnalyzer();

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        boolean withParentheses = lexes.is("(");
        if (withParentheses) {
            lexes.next();
        }
        ArrayList<WithPair> pairs = new ArrayList<WithPair>();
        while (true) {
            Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
            if (lexes.is("as")) {
                lexes.next();
                if (!lexes.isIdentifier()) {
                    throw new ExecutionException("as has to be followed by an identifier", new Object[0]);
                }
                Lex id = lexes.next();
                pairs.add(new WithPair(expression, id.text()));
            } else {
                pairs.add(new WithPair(expression, null));
            }
            if (!lexes.is(",")) break;
            lexes.next();
        }
        WithAnalyzer.checkClosingParen(lexes, withParentheses);
        Command body = WithAnalyzer.getBody(lexes);
        return new WithCommand((WithPair[])pairs.toArray(WithPair[]::new), body);
    }

    private static void checkClosingParen(LexList lexes, boolean withParentheses) throws BadSyntax {
        if (withParentheses) {
            BadSyntax.when(lexes, lexes.isNot(")"), "You have to close the parentheses in the 'for' or 'while' loop and 'with'", new Object[0]);
            lexes.next();
        } else {
            BadSyntax.when(lexes, lexes.isNot(":", "{"), "'for' or 'while' loop and 'with' body has to be after '{' or ':'", new Object[0]);
        }
    }

    private static Command getBody(LexList lexes) throws BadSyntax {
        Command body;
        if (lexes.is(":")) {
            lexes.next();
            body = CommandAnalyzer.INSTANCE.analyze(lexes);
        } else if (lexes.is("{")) {
            body = BlockAnalyzer.UNWRAPPED.analyze(lexes);
        } else {
            throw lexes.syntaxError(": or { is expected after the keyword 'with'", new Object[0]);
        }
        return body;
    }

    public record WithPair(Command command, String alias) {
        public static WithPair factory(Unmarshaller.Args args) {
            return new WithPair(args.command("command"), args.str("alias"));
        }
    }
}

