/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.analyzer.Pos;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.LngList;
import ch.turic.memory.LngObject;
import ch.turic.memory.LngStackFrame;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractCommand
implements Command,
HasFields {
    private Pos startPosition;
    private Pos endPosition;
    private volatile LngObject lngObjectRef = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LngObject toLngObject(Context context) {
        if (this.lngObjectRef == null) {
            AbstractCommand abstractCommand = this;
            synchronized (abstractCommand) {
                if (this.lngObjectRef == null) {
                    this.lngObjectRef = this._toLngObject(context);
                }
            }
        }
        return this.lngObjectRef;
    }

    public LngObject _toLngObject(Context context) throws ExecutionException {
        return this._toLngObject(this, context);
    }

    private LngObject _toLngObject(Object object, Context context) throws ExecutionException {
        try {
            LngObject lngObject = LngObject.newEmpty(context);
            lngObject.setField("java$canonicalName", object.getClass().getCanonicalName());
            for (Field f : object.getClass().getDeclaredFields()) {
                String name = f.getName();
                int modifiers = f.getModifiers();
                if (f.isSynthetic() || (modifiers & 0x10) == 0 || (modifiers & 8) != 0) continue;
                if (f.getType().isArray()) {
                    LngList list = new LngList();
                    lngObject.setField(name, list);
                    f.setAccessible(true);
                    Object array = f.get(object);
                    if (array == null) continue;
                    int length = Array.getLength(array);
                    for (int i = 0; i < length; ++i) {
                        list.array.add(this.cast2Lang(context, Array.get(array, i)));
                    }
                    continue;
                }
                f.setAccessible(true);
                Object value = f.get(object);
                if (value == null) continue;
                lngObject.setField(name, this.cast2Lang(context, value));
            }
            return lngObject;
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException(e);
        }
    }

    private LngList _toLngList(Object object, Context context) throws ExecutionException {
        LngList lngList = new LngList();
        int length = Array.getLength(object);
        for (int i = 0; i < length; ++i) {
            lngList.array.add(this.cast2Lang(context, Array.get(object, i)));
        }
        return lngList;
    }

    private LngObject castMap(Context context, Map<?, ?> map) throws ExecutionException {
        LngObject lngObject = LngObject.newEmpty(context);
        map.forEach((? super K key, ? super V value) -> lngObject.setField(key.toString(), this.cast2Lang(context, value)));
        return lngObject;
    }

    private Object cast2Lang(Context context, Object command) {
        if (command.getClass().isArray()) {
            return this._toLngList(command, context);
        }
        Object object = command;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractCommand.class, String.class, Long.class, Double.class, Boolean.class, Map.class}, (Object)object2, n)) {
            case 0 -> {
                AbstractCommand cmd = (AbstractCommand)object2;
                yield cmd.toLngObject(context);
            }
            case 1 -> {
                String s = (String)object2;
                yield s;
            }
            case 2 -> {
                Long s = (Long)object2;
                yield s;
            }
            case 3 -> {
                Double s = (Double)object2;
                yield s;
            }
            case 4 -> {
                Boolean s = (Boolean)object2;
                yield s;
            }
            case 5 -> {
                Map m = (Map)object2;
                yield this.castMap(context, m);
            }
            default -> this._toLngObject(command, context);
        };
    }

    public Pos startPosition() {
        return this.startPosition;
    }

    public Pos endPosition() {
        return this.endPosition;
    }

    public void setEndPosition(Pos endPosition) {
        this.endPosition = endPosition;
    }

    public void setStartPosition(Pos startPosition) {
        this.startPosition = startPosition;
    }

    @Override
    public Object execute(Context ctx) throws ExecutionException {
        LngStackFrame sf = new LngStackFrame(this);
        ctx.threadContext.push(sf);
        Object result = this._execute(ctx);
        ctx.threadContext.pop();
        return result;
    }

    public abstract Object _execute(Context var1) throws ExecutionException;

    @Override
    public void setField(String name, Object value) throws ExecutionException {
        throw new ExecutionException("Commands are immutable objects", new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getField(String name) throws ExecutionException {
        Object object;
        switch (name) {
            case "java$canonicalName": {
                String string = this.getClass().getCanonicalName();
                object = string;
                return object;
            }
        }
        try {
            Field f = this.getClass().getDeclaredField(name);
            f.setAccessible(true);
            Object value = f.get(this);
            if (!f.getType().isArray()) {
                Object object2;
                object = object2 = value;
                return object;
            }
            LngList list = new LngList();
            if (value != null) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    list.array.add(Array.get(value, i));
                }
            }
            LngList lngList = list;
            object = lngList;
            return object;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExecutionException("There is no such field: " + name, new Object[0]);
        }
    }

    @Override
    public Set<String> fields() {
        HashSet<String> fieldSet = new HashSet<String>();
        fieldSet.add("java$canonicalName");
        for (Field f : this.getClass().getDeclaredFields()) {
            String name = f.getName();
            int modifiers = f.getModifiers();
            if (f.isSynthetic() || (modifiers & 0x10) == 0 || (modifiers & 8) != 0) continue;
            fieldSet.add(name);
        }
        return fieldSet;
    }
}

