/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.analyzer.AssignmentList;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.TypeDeclaration;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.utils.Unmarshaller;
import java.util.Iterator;

public class MultiLetAssignment
extends AbstractCommand {
    final AssignmentList.Assignment[] assignments;
    final Command rightHandSide;
    final Type type;
    final boolean mut;

    public static MultiLetAssignment factory(Unmarshaller.Args args) {
        return new MultiLetAssignment(args.get("assignments", AssignmentList.Assignment[].class), args.command("rightHandSide"), args.get("type", Type.class), args.bool("mut"));
    }

    public MultiLetAssignment(AssignmentList.Assignment[] assignments, Command rightHandSide, Type type, boolean mut) {
        this.assignments = assignments;
        this.rightHandSide = rightHandSide;
        this.type = type;
        this.mut = mut;
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        Object value = this.rightHandSide.execute(ctx);
        switch (this.type.ordinal()) {
            case 1: {
                this.handleObjectAssignment(ctx, value);
                break;
            }
            case 0: {
                this.handleListAssignment(ctx, value);
            }
        }
        return value;
    }

    private void handleListAssignment(Context ctx, Object value) {
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            Iterator iterator = iterable.iterator();
            for (AssignmentList.Assignment assignment : this.assignments) {
                ctx.step();
                String[] typeNames = this.getTypeNames(ctx, assignment);
                if (!iterator.hasNext()) {
                    throw new ExecutionException("[multi-let] assignment right hand side has too few values", value);
                }
                this.defineOrUpdate(ctx, assignment.identifier(), iterator.next(), typeNames);
            }
            if (iterator.hasNext()) {
                throw new ExecutionException("[multi-let] assignment right hand side has too many values", value);
            }
        } else {
            throw new ExecutionException("[multi-let] assignment got a %s value not a list", value);
        }
    }

    private void handleObjectAssignment(Context ctx, Object value) {
        if (value instanceof HasFields) {
            HasFields fields = (HasFields)value;
            for (AssignmentList.Assignment assignment : this.assignments) {
                ctx.step();
                String[] typeNames = this.getTypeNames(ctx, assignment);
                this.defineOrUpdate(ctx, assignment.identifier(), fields.getField(assignment.identifier()), typeNames);
            }
        } else {
            throw new ExecutionException("{multi-let} assignment got a %s value does not have fields", value);
        }
    }

    private void defineOrUpdate(Context ctx, String identifier, Object value, String[] typeNames) {
        if (this.mut) {
            if (typeNames != null && typeNames.length > 0) {
                ctx.defineTypeChecked(identifier, value, typeNames);
            } else if (ctx.contains(identifier)) {
                ctx.update(identifier, value);
            } else {
                ctx.defineTypeChecked(identifier, value, typeNames);
            }
        } else {
            ctx.defineTypeChecked(identifier, value, typeNames);
            ctx.freeze(identifier);
        }
    }

    private String[] getTypeNames(Context ctx, AssignmentList.Assignment assignment) {
        String[] typeNames;
        if (assignment.types() == null) {
            typeNames = null;
        } else {
            typeNames = new String[assignment.types().length];
            for (int i = 0; i < assignment.types().length; ++i) {
                TypeDeclaration type = assignment.types()[i];
                typeNames[i] = type.calculateTypeName(ctx);
            }
        }
        return typeNames;
    }

    public static enum Type {
        LIST,
        OBJECT;

    }
}

