/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands.operators;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.operators.AbstractOperator;
import ch.turic.commands.operators.Cast;
import ch.turic.commands.operators.Operator;
import ch.turic.memory.Context;
import ch.turic.memory.LngList;

@Operator.Symbol(value="*")
public class Multiply
extends AbstractOperator {
    @Override
    public Object binaryOp(Context ctx, Object op1, Command right) throws ExecutionException {
        Object op2 = right.execute(ctx);
        if (op1 instanceof CharSequence) {
            CharSequence s = (CharSequence)op1;
            if (Cast.isLong(op2)) {
                Long n = Cast.toLong(op2);
                if (n > Integer.MAX_VALUE || n < Integer.MIN_VALUE) {
                    throw new ExecutionException("Cannot '%s' * '%s' too large", op2, n);
                }
                return s.toString().repeat(n.intValue());
            }
            throw new ExecutionException("Cannot '%s' * '%s'", op2, op1);
        }
        if (op1 instanceof LngList) {
            LngList list1 = (LngList)op1;
            if (op2 instanceof LngList) {
                LngList list2 = (LngList)op2;
                LngList product = new LngList(list1.getFieldProvider());
                for (Object a2 : list1.array) {
                    for (Object b2 : list2.array) {
                        LngList pair = new LngList();
                        pair.array.add(a2);
                        pair.array.add(b2);
                        product.array.add(pair);
                    }
                }
                return product;
            }
        }
        return this.binary("multiply", op1, op2, (a, b) -> a * b, (a, b) -> a * b);
    }
}

