/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.memory.Channel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingQueueChannel<T>
implements Channel<T> {
    private final BlockingQueue<Channel.Message<T>> queue;
    private volatile boolean closed = false;

    public BlockingQueueChannel(int capacity) {
        this.queue = new LinkedBlockingQueue<Channel.Message<T>>(capacity);
    }

    @Override
    public void send(Channel.Message<T> message) throws ExecutionException {
        try {
            if (this.isClosed()) {
                throw new ExecutionException("Channel is closed", new Object[0]);
            }
            if (message.isCloseMessage()) {
                Thread.startVirtualThread(() -> {
                    try {
                        this.queue.put(message);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
            } else {
                this.queue.put(message);
            }
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public boolean trySend(Channel.Message<T> message) throws ExecutionException {
        if (this.isClosed()) {
            throw new ExecutionException("Channel is closed", new Object[0]);
        }
        return this.queue.offer(message);
    }

    @Override
    public boolean trySend(Channel.Message<T> message, long time, TimeUnit unit) throws ExecutionException {
        try {
            if (this.isClosed()) {
                throw new ExecutionException("Channel is closed", new Object[0]);
            }
            return this.queue.offer(message, time, unit);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public Channel.Message<T> receive() throws ExecutionException {
        try {
            return this.queue.take();
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public Channel.Message<T> tryReceive() throws ExecutionException {
        return (Channel.Message)this.queue.poll();
    }

    @Override
    public Channel.Message<T> tryReceive(long time, TimeUnit unit) throws ExecutionException {
        try {
            return this.queue.poll(time, unit);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            Channel.super.close();
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

