package ch.turic;

/**
 * Represents an execution context for the Turi language.
 * This interface defines the contract for managing scope, variables,
 * and state during the execution of Turi code. The context is used
 * throughout the language implementation for maintaining execution
 * environment, variable bindings, and other runtime state.
 *
 * <p>The context is essential for operations such as:
 * <ul>
 *   <li>Variable scoping and management</li>
 *   <li>Function execution environments</li>
 *   <li>Exception handling context</li>
 *   <li>State management during evaluation</li>
 * </ul>
 *
 */
public interface Context {
}
