/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.LeftValueAnalyzer;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.Lexer;
import ch.turic.commands.Assignment;
import ch.turic.commands.IncrementDecrement;
import ch.turic.memory.LeftValue;

public class AssignmentAnalyzer
extends AbstractAnalyzer {
    public static final AssignmentAnalyzer INSTANCE = new AssignmentAnalyzer();

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        if (lexes.is("++")) {
            lexes.next();
            LeftValue leftValue = LeftValueAnalyzer.INSTANCE.analyze(lexes);
            if (leftValue == null) {
                throw lexes.syntaxError("Invalid left value following ++", new Object[0]);
            }
            return new IncrementDecrement(leftValue, true, false);
        }
        if (lexes.is("--")) {
            lexes.next();
            LeftValue leftValue = LeftValueAnalyzer.INSTANCE.analyze(lexes);
            if (leftValue == null) {
                throw lexes.syntaxError("Invalid left value following ++", new Object[0]);
            }
            return new IncrementDecrement(leftValue, false, false);
        }
        LeftValue leftValue = LeftValueAnalyzer.INSTANCE.analyze(lexes);
        if (leftValue == null) {
            return null;
        }
        if (!lexes.hasNext() || lexes.peek().type() != Lex.Type.RESERVED) {
            return null;
        }
        if (lexes.is("++")) {
            lexes.next();
            return new IncrementDecrement(leftValue, true, true);
        }
        if (lexes.is("--")) {
            lexes.next();
            return new IncrementDecrement(leftValue, false, true);
        }
        if (!this.isAssignmentOperator(lexes)) {
            return null;
        }
        String op = lexes.next().text();
        Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
        return new Assignment(leftValue, op.substring(0, op.length() - 1), expression);
    }

    private boolean isAssignmentOperator(LexList lexes) {
        return lexes.is(Lexer.ASSIGNMENT_OPERATORS);
    }
}

