/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.commands.JsonConstant;
import java.util.HashMap;

public class JsonStructureAnalyzer
extends AbstractAnalyzer {
    public static final JsonStructureAnalyzer INSTANCE = new JsonStructureAnalyzer();

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        boolean lazy = lexes.is("&{");
        lexes.next();
        HashMap<String, Command> fields = new HashMap<String, Command>();
        while (lexes.isIdentifier() || lexes.peek().type() == Lex.Type.STRING) {
            String key = lexes.next().text();
            ExecutionException.when(lexes.isNot(":"), ": is missing after key in JSON object", new Object[0]);
            lexes.next();
            Command value = ExpressionAnalyzer.INSTANCE.analyze(lexes);
            fields.put(key, value);
            if (!lexes.is(",")) continue;
            lexes.next();
        }
        ExecutionException.when(lexes.isNot("}"), "JSON Structure has to be closed with }", new Object[0]);
        lexes.next();
        return new JsonConstant(fields, lazy);
    }
}

