/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.classes;

import ch.turic.ExecutionException;
import ch.turic.LngCallable;
import ch.turic.TuriClass;
import ch.turic.builtins.classes.TuriMethod;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class TuriInputStream
implements TuriClass {
    @Override
    public Class<?> forClass() {
        return InputStream.class;
    }

    @Override
    public LngCallable getMethod(Object target, String identifier) throws ExecutionException {
        if (!(target instanceof InputStream)) {
            throw new ExecutionException("Target object is not an InputStream, this is an internal error", new Object[0]);
        }
        InputStream is = (InputStream)target;
        return switch (identifier) {
            case "read_all_bytes" -> new TuriMethod<byte[]>(args -> is.readAllBytes());
            case "read" -> new TuriMethod<Integer>(args -> is.read());
            case "read_char" -> new TuriMethod<String>(args -> {
                InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
                int ch = reader.read();
                if (ch == -1) {
                    return null;
                }
                return new String(Character.toChars(ch));
            });
            case "available" -> new TuriMethod<Integer>(args -> is.available());
            case "close" -> new TuriMethod<Object>(args -> {
                is.close();
                return null;
            });
            case "read_all" -> new TuriMethod<String>(args -> new String(is.readAllBytes(), StandardCharsets.UTF_8));
            default -> throw new ExecutionException("Invalid method '" + identifier + "' for input stream.", new Object[0]);
        };
    }
}

