/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.commands.ClosureLike;
import ch.turic.commands.FunctionCallOrCurry;

public class UnCurry
implements TuriFunction {
    @Override
    public String name() {
        return "uncurry";
    }

    @Override
    public Object call(Context context, Object[] arguments) throws ExecutionException {
        FunUtils.ArgumentsHolder args = FunUtils.args(this.name(), arguments, ClosureLike.class, FunUtils.ArgumentsHolder.optional(Long.class));
        ClosureLike closureLike = args.at(0).as(ClosureLike.class);
        FunUtils.Argument steps = args.at(1);
        if (closureLike.getCurriedSelf() == null && closureLike.getCurriedArguments() == null) {
            throw new ExecutionException("Cannot uncurry a non curried macro, closure, or function", new Object[0]);
        }
        try {
            ClosureLike unCurried = closureLike.clone();
            if (!steps.isPresent()) {
                unCurried.setCurriedSelf(null);
                unCurried.setCurriedArguments(null);
            } else {
                Long level = steps.as(Long.class);
                FunctionCallOrCurry.ArgumentEvaluated[] oldArgs = unCurried.getCurriedArguments();
                FunctionCallOrCurry.ArgumentEvaluated[] uncurriedArgs = new FunctionCallOrCurry.ArgumentEvaluated[oldArgs.length - level.intValue()];
                System.arraycopy(oldArgs, 0, uncurriedArgs, 0, uncurriedArgs.length);
                unCurried.setCurriedArguments(uncurriedArgs);
            }
            return unCurried;
        }
        catch (CloneNotSupportedException e) {
            throw new ExecutionException("Cannot uncurry a curried macro, closure, or function, clone failed", new Object[0]);
        }
    }
}

