/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.macros;

import ch.turic.Command;
import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.Interpreter;
import ch.turic.TuriMacro;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.commands.FieldAccess;
import ch.turic.commands.Identifier;
import ch.turic.memory.LngList;
import ch.turic.memory.LngObject;
import ch.turic.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class Import
implements TuriMacro {
    public static final String APPIA = "APPIA";
    private final List<Path> appiaRoots = Import.getAppiaRoots();

    @Override
    public String name() {
        return "import";
    }

    @Override
    public Object call(Context context, Object[] arguments) throws ExecutionException {
        ch.turic.memory.Context ctx = FunUtils.ctx(context);
        Object argO = FunUtils.oneOrMoreArgs(this.name(), arguments);
        if (!(argO instanceof Command)) {
            throw new ExecutionException("Import needs a string first argument", new Object[0]);
        }
        Command cmd = (Command)argO;
        String arg = Import.getImportString(cmd, ctx);
        Path sourceFile = this.locateSource(ctx, arg);
        try {
            String source = Files.readString(sourceFile, StandardCharsets.UTF_8);
            List<String> imports = Import.getImportsList(arguments, ctx);
            return Import.doImportExport(ctx, source, imports);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot read the import file '%s'", sourceFile.toString());
        }
    }

    static List<String> getImportsList(Object[] args, ch.turic.memory.Context ctx) {
        ArrayList<String> imports = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            Object object = args[i];
            if (object instanceof Identifier) {
                Identifier id = (Identifier)object;
                imports.add(id.name());
                continue;
            }
            object = args[i];
            if (!(object instanceof Command)) continue;
            Command command = (Command)object;
            imports.add(Import.getImportString(command, ctx));
        }
        return imports;
    }

    static Object doImportExport(ch.turic.memory.Context ctx, String source, List<String> imports) {
        Interpreter interpreter = new Interpreter(source);
        interpreter.compileAndExecute();
        ch.turic.memory.Context importedContext = (ch.turic.memory.Context)interpreter.getImportContext();
        HashSet<String> set = new HashSet<String>();
        for (String exported : imports == null || imports.isEmpty() ? importedContext.exporting() : imports) {
            for (String k : importedContext.keys()) {
                if (!StringUtils.matches(exported, k)) continue;
                set.add(k);
            }
        }
        for (String exported : set) {
            ctx.let0(exported, importedContext.get(exported));
        }
        return new LngObject(null, importedContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Path locateSource(ch.turic.memory.Context context, String arg) {
        String appiaSource;
        List<Path> appiaRoots;
        Path relativePath = Path.of(arg.replace('.', File.separatorChar) + ".turi", new String[0]);
        if (context.contains(APPIA)) {
            Object appia = context.get(APPIA);
            if (!(appia instanceof LngList)) throw new ExecutionException("There is an APPIA variable defined, but it is not a list. APPIA=%s", Objects.requireNonNullElse(appia, "none").toString());
            LngList appiaList = (LngList)appia;
            appiaRoots = this.getAppiaRootsFrom(appiaList);
            appiaSource = "global variable";
        } else {
            appiaRoots = this.appiaRoots;
            appiaSource = "environment variable";
        }
        Path sourceFile = null;
        for (Path root : appiaRoots) {
            Path candidate = root.resolve(relativePath);
            if (!Files.exists(candidate, new LinkOption[0])) continue;
            sourceFile = candidate;
            break;
        }
        if (sourceFile != null) return sourceFile;
        throw new ExecutionException("There is no import '%s' via APPIA(%s)=[%s], cwd=%s", arg, appiaSource, String.join((CharSequence)"|", appiaRoots.stream().map(Path::toString).toList()), new File(".").getAbsolutePath());
    }

    private List<Path> getAppiaRootsFrom(LngList appiaList) {
        List<Path> appiaRoots = Import.toPathList(appiaList.array.stream().map(o -> Objects.requireNonNullElse(o, "none")).map(Object::toString));
        return appiaRoots;
    }

    private static List<Path> toPathList(Stream<String> stringStream) {
        return stringStream.map(String::trim).filter(s -> !s.isEmpty()).map(x$0 -> Path.of(x$0, new String[0])).map(Path::normalize).map(Path::toAbsolutePath).toList();
    }

    private static List<Path> getAppiaRoots() {
        String appia = System.getProperty(APPIA);
        if (appia == null) {
            System.getenv(APPIA);
        }
        if (appia == null) {
            appia = Import.loadFromEnvFile();
        }
        if (appia == null || appia.isBlank()) {
            return List.of();
        }
        return Import.toPathList(Arrays.stream(appia.split("\\|")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadFromEnvFile() {
        Path current = Path.of("", new String[0]).toAbsolutePath();
        while (current != null) {
            try {
                Path envPath = current.resolve(".env");
                if (!Files.exists(envPath, new LinkOption[0]) || !Files.isReadable(envPath)) continue;
                List<String> lines = Files.readAllLines(envPath, StandardCharsets.UTF_8);
                for (String line : lines) {
                    String trimmed = line.trim();
                    if (!trimmed.startsWith("APPIA=")) continue;
                    String string = trimmed.substring("APPIA=".length()).trim();
                    return string;
                }
            }
            catch (IOException iOException) {}
            continue;
            finally {
                current = current.getParent();
            }
        }
        return null;
    }

    static String getImportString(Command cmd, ch.turic.memory.Context ctx) {
        if (cmd instanceof Identifier) {
            Identifier id = (Identifier)cmd;
            return id.name();
        }
        if (cmd instanceof FieldAccess) {
            StringBuilder sb = new StringBuilder();
            Command fa = cmd;
            while (fa instanceof FieldAccess) {
                FieldAccess f = (FieldAccess)fa;
                sb.insert(0, "." + f.identifier());
                fa = f.object();
            }
            if (fa instanceof Identifier) {
                Identifier id = (Identifier)fa;
                sb.insert(0, id.name());
                return sb.toString();
            }
        }
        return cmd.execute(ctx).toString();
    }
}

