/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.Closure;
import ch.turic.memory.Context;
import ch.turic.memory.LngObject;
import ch.turic.utils.Unmarshaller;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class Print
extends AbstractCommand {
    private static final String PRINT_TARGET = "print_target";
    private static final String WRITE = "write";
    private static final String FLUSH = "flush";
    private final Command[] commands;
    private final boolean nl;

    public static Print factory(Unmarshaller.Args args) {
        return new Print(args.commands(), args.bool("nl"));
    }

    public Print(Command[] commands, boolean nl) {
        this.commands = commands;
        this.nl = nl;
    }

    private static void out(String str, Context ctx, Object outputHandle) {
        if (outputHandle == null) {
            System.out.print(str);
        } else {
            Object object = outputHandle;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LngObject.class, Closure.class}, (Object)object2, n)) {
                case 0: {
                    LngObject outputHandlerObject = (LngObject)object2;
                    Object entry = outputHandlerObject.getField(WRITE);
                    if (!(entry instanceof Closure)) {
                        throw new ExecutionException("output handler does not have '%s()' method", WRITE);
                    }
                    Closure closure = (Closure)entry;
                    closure.callAsMethod(ctx, outputHandlerObject, WRITE, str);
                    break;
                }
                case 1: {
                    Closure closure = (Closure)object2;
                    closure.call(ctx, str);
                    break;
                }
                default: {
                    throw new ExecutionException("unhandled output handle: " + String.valueOf(outputHandle), new Object[0]);
                }
            }
        }
    }

    private static void flush(Context ctx, Object outputHandle) {
        if (outputHandle == null) {
            System.out.flush();
        }
        if (outputHandle instanceof LngObject) {
            LngObject outputHandleObject = (LngObject)outputHandle;
            Object entry = outputHandleObject.getField(FLUSH);
            if (!(entry instanceof Closure)) {
                if (entry != null) {
                    throw new ExecutionException("output handler 'flush()' is not a method %s", entry);
                }
                return;
            }
            Closure closure = (Closure)entry;
            closure.callAsMethod(ctx, outputHandleObject, FLUSH, new Object[0]);
        }
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        Object printTarget;
        Object object = printTarget = ctx.contains(PRINT_TARGET) ? ctx.get(PRINT_TARGET) : null;
        if (printTarget != null && !(printTarget instanceof LngObject) && !(printTarget instanceof Closure)) {
            throw new ExecutionException("Output must be an object or closure", new Object[0]);
        }
        for (Command cmd : this.commands) {
            Object arg;
            Object object2 = arg = cmd.execute(ctx);
            int n = 0;
            String str = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{}, (Object)object2, n)) {
                case -1 -> "none";
                default -> String.valueOf(arg);
            };
            Print.out(str, ctx, printTarget);
        }
        if (this.nl) {
            Print.out("\n", ctx, printTarget);
        }
        Print.flush(ctx, printTarget);
        return null;
    }
}

