/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands.operators;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.ChainedClosure;
import ch.turic.commands.ChainedMacro;
import ch.turic.commands.Closure;
import ch.turic.commands.ClosureLike;
import ch.turic.commands.FunctionCall;
import ch.turic.commands.FunctionCallOrCurry;
import ch.turic.commands.Macro;
import ch.turic.commands.TryCatch;
import ch.turic.commands.operators.Cast;
import ch.turic.commands.operators.Operator;
import ch.turic.commands.operators.Reflect;
import ch.turic.memory.Context;
import ch.turic.memory.LngObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public abstract class AbstractOperator
implements Operator {
    @Override
    public final Object execute(Context context, Command left, Command right) throws ExecutionException {
        Object op1;
        if (left == null) {
            Object op2;
            Context shadowed = context.shadow();
            try {
                op2 = right.execute(shadowed);
                TryCatch.exportFromTemporaryContext(shadowed, context);
            }
            catch (ExecutionException e) {
                return this.exceptionHandler(shadowed, e, right);
            }
            if (!(op2 instanceof LngObject)) {
                return this.unaryOp(context, op2);
            }
            LngObject lngObject = (LngObject)op2;
            Object operatorMethod = lngObject.getField(this.symbol());
            if (operatorMethod == null) {
                return this.unaryOp(context, op2);
            }
            if (operatorMethod instanceof ClosureLike) {
                Context ctx;
                ClosureLike command = (ClosureLike)operatorMethod;
                ExecutionException.when(!command.parameters().fitOperator(), "Operator methods must have exactly one argument", new Object[0]);
                FunctionCallOrCurry.ArgumentEvaluated[] argValues = new FunctionCallOrCurry.ArgumentEvaluated[]{new FunctionCallOrCurry.ArgumentEvaluated(null, null)};
                if (command.wrapped() == null) {
                    ctx = context.wrap(lngObject.context());
                } else {
                    ctx = context.wrap(command.wrapped());
                    ctx.let0("this", lngObject);
                }
                FunctionCall.freezeThisAndCls(ctx);
                FunctionCall.defineArgumentsInContext(ctx, context, command.parameters(), argValues, true);
                return command.execute(ctx);
            }
            throw new ExecutionException("You can not execute the operator " + String.valueOf(operatorMethod) + " on a " + String.valueOf(op2), new Object[0]);
        }
        Context shadowed = context.shadow();
        try {
            op1 = left.execute(shadowed);
            TryCatch.exportFromTemporaryContext(shadowed, context);
        }
        catch (ExecutionException e) {
            return this.exceptionHandler(shadowed, e, right);
        }
        if (!(op1 instanceof LngObject)) {
            return this.binaryOp(context, op1, right);
        }
        LngObject lngObject = (LngObject)op1;
        Object operatorMethod = lngObject.getField(this.symbol());
        if (operatorMethod == null) {
            return this.binaryOp(context, op1, right);
        }
        if (operatorMethod instanceof ClosureLike) {
            ClosureLike command = (ClosureLike)operatorMethod;
            ExecutionException.when(!command.parameters().fitOperator(), "Operator methods must have exactly one argument", new Object[0]);
            FunctionCallOrCurry.ArgumentEvaluated[] argumentEvaluatedArray = new FunctionCallOrCurry.ArgumentEvaluated[1];
            ClosureLike closureLike = command;
            Objects.requireNonNull(closureLike);
            Object ctx = closureLike;
            int n = 0;
            argumentEvaluatedArray[0] = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Closure.class, ChainedClosure.class, Macro.class, ChainedMacro.class}, (Object)ctx, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Closure ignored = (Closure)ctx;
                    yield new FunctionCallOrCurry.ArgumentEvaluated(null, right.execute(context));
                }
                case 1 -> {
                    ChainedClosure ignored = (ChainedClosure)ctx;
                    yield new FunctionCallOrCurry.ArgumentEvaluated(null, right.execute(context));
                }
                case 2 -> {
                    Macro ignored = (Macro)ctx;
                    yield new FunctionCallOrCurry.ArgumentEvaluated(null, right);
                }
                case 3 -> {
                    ChainedMacro ignored = (ChainedMacro)ctx;
                    yield new FunctionCallOrCurry.ArgumentEvaluated(null, right);
                }
            };
            FunctionCallOrCurry.ArgumentEvaluated[] argValues = argumentEvaluatedArray;
            if (command.wrapped() == null) {
                ctx = context.wrap(lngObject.context());
            } else {
                ctx = context.wrap(command.wrapped());
                ((Context)ctx).let0("this", lngObject);
            }
            ((Context)ctx).setCaller(context);
            FunctionCall.freezeThisAndCls((Context)ctx);
            FunctionCall.defineArgumentsInContext((Context)ctx, context, command.parameters(), argValues, true);
            return command.execute((Context)ctx);
        }
        return this.binaryOp(context, op1, right);
    }

    public Object unaryOp(Context ctx, Object op) throws ExecutionException {
        throw new ExecutionException(this.symbol(), "is not an unary operator");
    }

    public abstract Object binaryOp(Context var1, Object var2, Command var3) throws ExecutionException;

    public Object exceptionHandler(Context ctx, ExecutionException t, Command right) throws ExecutionException {
        throw t;
    }

    protected Object binary(String name, Object op1, Object op2, BiFunction<Long, Long, Long> longOp, BiFunction<Double, Double, Double> doubleOp) throws ExecutionException {
        Supplier<String> symbol = () -> this.getClass().getAnnotation(Operator.Symbol.class).value();
        ExecutionException.when(op1 == null || op2 == null, "You cannot '%s' on undefined value", symbol.get());
        if (longOp != null && Cast.isLong(op1) && Cast.isLong(op2)) {
            return longOp.apply(Cast.toLong(op1), Cast.toLong(op2));
        }
        if (doubleOp != null && (Cast.isDouble(op1) || Cast.isDouble(op2))) {
            return doubleOp.apply(Cast.toDouble(op1), Cast.toDouble(op2));
        }
        return Reflect.getBinaryMethod(name, op1, op2).map(Reflect.Op::callMethod).orElseThrow(() -> new ExecutionException("Cannot calculate '%s' %s '%s'", op1, symbol.get(), op2));
    }
}

