/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands.operators;

import ch.turic.ExecutionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;

class Reflect {
    private final Method method;
    private final Object op1;
    private final Object op2;
    private final String name;

    private Reflect(Method method, Object op1, Object op2, String name) {
        this.method = method;
        this.op1 = op1;
        this.op2 = op2;
        this.name = name;
    }

    static Optional<Op> getBinaryMethod(String name, Object op1, Object op2) {
        try {
            Method method = op1.getClass().getMethod(name, op2.getClass());
            if (method.isSynthetic() || Modifier.isStatic(method.getModifiers())) {
                return Optional.empty();
            }
            return Optional.of(new Reflect(method, op1, op2, name).new Binary());
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    static Optional<Op> getUnaryMethod(String name, Object op) {
        try {
            Method method = op.getClass().getMethod(name, new Class[0]);
            if (method.isSynthetic() || Modifier.isStatic(method.getModifiers())) {
                return Optional.empty();
            }
            return Optional.of(new Reflect(method, op, null, name).new Unary());
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    class Binary
    implements Op {
        Binary() {
        }

        @Override
        public Object callMethod() throws ExecutionException {
            try {
                return Reflect.this.method.invoke(Reflect.this.op1, Reflect.this.op2);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ExecutionException("Error calling the method " + Reflect.this.name + " on " + Reflect.this.op1.getClass().getName(), new Object[]{e});
            }
        }
    }

    class Unary
    implements Op {
        Unary() {
        }

        @Override
        public Object callMethod() throws ExecutionException {
            try {
                return Reflect.this.method.invoke(Reflect.this.op1, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ExecutionException("Error calling the method " + Reflect.this.name + " on " + Reflect.this.op1.getClass().getName(), new Object[]{e});
            }
        }
    }

    static interface Op {
        public Object callMethod() throws ExecutionException;
    }
}

