/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.memory.ChannelIterator;
import ch.turic.memory.LngException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public interface Channel<T>
extends AutoCloseable,
Iterable<T> {
    @Override
    default public Iterator<T> iterator() {
        return new ChannelIterator(this);
    }

    @Override
    default public void close() {
        this.send(Message.closed());
    }

    public void send(Message<T> var1) throws ExecutionException;

    public boolean trySend(Message<T> var1) throws ExecutionException;

    public boolean trySend(Message<T> var1, long var2, TimeUnit var4) throws ExecutionException;

    public Message<T> receive() throws ExecutionException;

    public Message<T> tryReceive() throws ExecutionException;

    public Message<T> tryReceive(long var1, TimeUnit var3) throws ExecutionException;

    public boolean isClosed();

    public static interface Message<T> {
        public boolean isEmpty();

        default public boolean isPresent() {
            return !this.isEmpty();
        }

        public boolean isCloseMessage();

        public boolean isException();

        public T get();

        public T _get();

        public static <T> Message<T> of(T value) {
            return new SimpleMessage<T>(value, Type.OBJECT);
        }

        public static <T> Message<T> empty() {
            return new SimpleMessage<Object>(null, Type.NULL);
        }

        public static <T> Message<T> closed() {
            return new SimpleMessage<Object>(null, Type.END);
        }

        public static Message<LngException> exception(LngException throwable) {
            return new SimpleMessage<LngException>(throwable, Type.EXCEPTION);
        }

        public static enum Type {
            OBJECT,
            NULL,
            END,
            EXCEPTION;

        }
    }

    public static class SimpleMessage<T>
    implements Message<T> {
        final Message.Type type;
        final T value;

        private SimpleMessage(T value, Message.Type type) {
            this.type = type;
            this.value = value;
        }

        @Override
        public boolean isEmpty() {
            return this.type == Message.Type.NULL;
        }

        @Override
        public boolean isException() {
            return this.type == Message.Type.EXCEPTION;
        }

        @Override
        public boolean isCloseMessage() {
            return this.type == Message.Type.END;
        }

        @Override
        public T _get() throws ExecutionException {
            return switch (this.type.ordinal()) {
                case 1 -> null;
                default -> this.value;
            };
        }

        @Override
        public T get() throws ExecutionException {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.value;
                case 1 -> null;
                case 2 -> throw new NoSuchElementException();
                case 3 -> {
                    if (this.value instanceof Throwable) {
                        throw new ExecutionException((Throwable)this.value);
                    }
                    T var2_1 = this.value;
                    if (var2_1 instanceof LngException) {
                        LngException lngException = (LngException)var2_1;
                        throw new ExecutionException(lngException.getCause());
                    }
                    throw new ExecutionException("Unkown message wrapped for exception '%s'", this.value);
                }
            };
        }
    }
}

