/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.LngCallable;
import ch.turic.commands.ClosureLike;
import ch.turic.commands.FunctionCall;
import ch.turic.commands.FunctionCallOrCurry;
import ch.turic.commands.Macro;
import ch.turic.memory.ClassContext;
import ch.turic.memory.Context;
import ch.turic.memory.HasContext;
import ch.turic.memory.HasFields;
import ch.turic.memory.HasIndex;
import ch.turic.memory.LngObject;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class LngClass
implements HasFields,
HasIndex,
HasContext,
LngCallable.LngCallableClosure {
    final ClassContext context;
    final String name;
    public final AtomicBoolean pinned = new AtomicBoolean(false);

    public LngClass(ClassContext context, String name) {
        this.context = context;
        this.name = name;
    }

    @Override
    public Context context() {
        return this.context;
    }

    public String name() {
        return this.name;
    }

    public Object newInstance(Object that, Context callerContext, FunctionCallOrCurry.Argument[] arguments) {
        Context objectContext = callerContext.wrap(this.context());
        LngObject uninitialized = new LngObject(this, objectContext);
        if (that != null) {
            objectContext.local("that", that);
            objectContext.freeze("that");
        }
        objectContext.local("this", uninitialized);
        objectContext.local("cls", this);
        FunctionCall.freezeCls(objectContext);
        Object constructor = this.context().get("init");
        if (constructor instanceof ClosureLike) {
            ClosureLike command = (ClosureLike)constructor;
            return this.callConstructor(callerContext, arguments, command, objectContext);
        }
        objectContext.freeze("this");
        return uninitialized;
    }

    private Object callConstructor(Context callerContext, FunctionCallOrCurry.Argument[] arguments, ClosureLike command, Context objectContext) {
        if (command instanceof Macro) {
            objectContext.setCaller(callerContext);
        }
        FunctionCallOrCurry.ArgumentEvaluated[] argValues = command.evaluateArguments(callerContext, arguments);
        FunctionCall.defineArgumentsInContext(objectContext, callerContext, command.parameters(), argValues, false);
        command.execute(objectContext);
        objectContext.freeze("this");
        return objectContext.get("this");
    }

    @Override
    public void setField(String name, Object value) throws ExecutionException {
        this.context.local(name, value);
    }

    @Override
    public Object getField(String name) throws ExecutionException {
        Object fieldInSelf = this.context.getLocal(name);
        if (fieldInSelf != null) {
            return fieldInSelf;
        }
        if (this.context.parents() != null) {
            for (LngClass parent : this.context.parents()) {
                Object fieldInParent = parent.getField(name);
                if (fieldInParent == null) continue;
                return fieldInParent;
            }
        }
        return null;
    }

    @Override
    public Set<String> fields() {
        return this.context.keys();
    }

    @Override
    public Object call(ch.turic.Context callerContext, Object[] arguments) throws ExecutionException {
        if (!(callerContext instanceof Context)) {
            throw new RuntimeException("Cannot work with this context implementation. This is an internal error.");
        }
        Context callerCtx = (Context)callerContext;
        Context objectContext = callerCtx.wrap(this.context);
        LngObject uninitialized = new LngObject(this, objectContext);
        objectContext.local("this", uninitialized);
        objectContext.local("cls", this);
        FunctionCall.freezeCls(objectContext);
        Object constructor = uninitialized.getField("init");
        if (constructor != null) {
            if (constructor instanceof ClosureLike) {
                ClosureLike closure = (ClosureLike)constructor;
                closure.execute(objectContext);
            } else {
                throw new ExecutionException("Constructor function is not callable", new Object[0]);
            }
        }
        Object object = objectContext.getLocal("this");
        objectContext.freeze("this");
        return object;
    }

    public boolean assignableTo(LngClass other) {
        if (other == this) {
            return true;
        }
        for (LngClass parent : this.context.parents()) {
            if (!parent.assignableTo(other)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("class %s", this.name);
    }

    @Override
    public void setIndex(Object index, Object value) throws ExecutionException {
        ExecutionException.when(this.pinned.get(), "You cannot change a pinned class", new Object[0]);
        this.setField(index.toString(), value);
    }

    @Override
    public Object getIndex(Object index) throws ExecutionException {
        return this.getField(index.toString());
    }

    @Override
    public Iterator<Object> iterator() {
        throw new ExecutionException("You cannot iterate over the field values.", new Object[0]);
    }
}

