/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.utils;

import ch.turic.ExecutionException;
import ch.turic.Program;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Marshaller {
    public static final short ARRAY_SIGN = 999;
    public static final short MAP_SIGN = 998;
    public static final short NULL_SIGN = 0;
    public static final int MAGIC = -891618626;
    public static final short VERSION = 1;
    public static final short OFFSET = 1000;
    private final Map<String, Short> classRegistry = new HashMap<String, Short>();
    private final ArrayList<String> classes = new ArrayList();
    private short registryCounter = (short)1000;

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize(Program program) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream buffer = new DataOutputStream(baos);){
                byte[] code = this.marshall(program);
                buffer.writeInt(-891618626);
                buffer.writeShort(1);
                buffer.writeShort(this.classes.size());
                for (String className : this.classes) {
                    buffer.writeUTF(className);
                }
                buffer.write(code);
                byte[] serialized = baos.toByteArray();
                byArray = this.compress(serialized);
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] compress(byte[] serialized) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] marshall(Object object) {
        if (object == null) {
            return new byte[]{0, 0};
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return this.marshall_map(map);
        }
        if (object.getClass().isArray()) {
            return this.marshall_array(object);
        }
        return this.marshall_non_array(object);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] marshall_map(Map<?, ?> map) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream buffer = new DataOutputStream(baos);){
                buffer.writeShort(998);
                buffer.writeInt(map.size());
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    buffer.write(this.marshall(entry.getKey()));
                    buffer.write(this.marshall(entry.getValue()));
                }
                object = baos.toByteArray();
            }
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] marshall_array(Object array) {
        if (array.getClass().isArray()) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (DataOutputStream buffer = new DataOutputStream(baos);){
                    buffer.writeShort(999);
                    int length = Array.getLength(array);
                    buffer.writeInt(length);
                    for (int i = 0; i < length; ++i) {
                        buffer.write(this.marshall(Array.get(array, i)));
                    }
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("marshall_array was called for non array");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] marshall_non_array(Object object) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object2;
            try (DataOutputStream buffer = new DataOutputStream(baos);){
                short id = this.getClassId(object);
                buffer.writeShort(id);
                Object object3 = object;
                Objects.requireNonNull(object3);
                object2 = object3;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Boolean.class, Long.class, Integer.class, Double.class, Enum.class}, (Object)object2, n)) {
                    case 0: {
                        String s = (String)object2;
                        buffer.writeUTF(s);
                        break;
                    }
                    case 1: {
                        Boolean b = (Boolean)object2;
                        buffer.writeBoolean(b);
                        break;
                    }
                    case 2: {
                        Long l = (Long)object2;
                        buffer.writeLong(l);
                        break;
                    }
                    case 3: {
                        Integer i = (Integer)object2;
                        buffer.writeInt(i);
                        break;
                    }
                    case 4: {
                        Double d = (Double)object2;
                        buffer.writeDouble(d);
                        break;
                    }
                    case 5: {
                        Enum e = (Enum)object2;
                        buffer.writeUTF(e.name());
                        break;
                    }
                    default: {
                        short fieldCounter = this.countFields(object);
                        buffer.writeShort(fieldCounter);
                        for (Field f : object.getClass().getDeclaredFields()) {
                            if (!this.isFieldToMarshall(f)) continue;
                            String name = f.getName();
                            buffer.writeUTF(name);
                            f.setAccessible(true);
                            buffer.write(this.marshall(f.get(object)));
                        }
                    }
                }
                object2 = baos.toByteArray();
            }
            return object2;
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private short countFields(Object object) {
        short fieldCounter = 0;
        for (Field f : object.getClass().getDeclaredFields()) {
            if (!this.isFieldToMarshall(f)) continue;
            fieldCounter = (short)(fieldCounter + 1);
        }
        return fieldCounter;
    }

    private boolean isFieldToMarshall(Field f) {
        int modifiers = f.getModifiers();
        return !f.isSynthetic() && (modifiers & 0x10) != 0 && (modifiers & 8) == 0;
    }

    private short getClassId(Object object) {
        String cname = object.getClass().getName();
        if (!this.classRegistry.containsKey(cname)) {
            short s = this.registryCounter;
            this.registryCounter = (short)(s + 1);
            this.classRegistry.put(cname, s);
            this.classes.add(cname);
        }
        return this.classRegistry.get(cname);
    }
}

