/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.codelounge.jsicko.plugin;

import ch.usi.si.codelounge.jsicko.Contract;
import ch.usi.si.codelounge.jsicko.plugin.ContractConditionEnum;
import ch.usi.si.codelounge.jsicko.plugin.JSickoContractCompilerState;
import ch.usi.si.codelounge.jsicko.plugin.diagnostics.JSickoDiagnostic;
import ch.usi.si.codelounge.jsicko.plugin.utils.JavacUtils;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class ConditionClause {
    private static Pattern clauseFormatRegexp = Pattern.compile("(\\!?)([A-Za-z][A-Za-z0-9_]*)");
    private final JavacUtils javac;
    private final JSickoContractCompilerState state;
    private final TreeMaker factory;
    private final boolean isNegated;
    private final Name methodName;
    private final ContractConditionEnum conditionType;
    private final String clauseRep;
    private Optional<Symbol.MethodSymbol> resolvedMethodSymbol;
    private final Symbol declaringSymbol;

    private ConditionClause(JSickoContractCompilerState state, JavacUtils javac, Symbol declaringSymbol, String clauseRep, ContractConditionEnum conditionType) {
        Matcher clauseRepFormatMatcher = clauseFormatRegexp.matcher(clauseRep);
        if (!clauseRepFormatMatcher.matches()) {
            throw new IllegalArgumentException("Clause specification name \"" + clauseRep + "\" is malformed. Please use a valid Java identifier / match regexp " + clauseFormatRegexp.toString());
        }
        this.state = state;
        this.javac = javac;
        this.factory = javac.getFactory();
        this.isNegated = !clauseRepFormatMatcher.group(1).isEmpty();
        this.methodName = javac.Name(clauseRepFormatMatcher.group(2));
        this.clauseRep = "clause " + clauseRep + " in " + declaringSymbol.owner.getSimpleName() + "#" + declaringSymbol.toString();
        this.declaringSymbol = declaringSymbol;
        this.conditionType = conditionType;
    }

    private ConditionClause(JSickoContractCompilerState state, JavacUtils javac, Symbol.MethodSymbol invariantSymbol) {
        this.state = state;
        this.javac = javac;
        this.factory = javac.getFactory();
        this.isNegated = false;
        this.methodName = invariantSymbol.name;
        this.clauseRep = "clause " + invariantSymbol + " in " + invariantSymbol.owner.getSimpleName();
        this.conditionType = ContractConditionEnum.INVARIANT;
        this.declaringSymbol = invariantSymbol.owner;
        this.resolvedMethodSymbol = Optional.of(invariantSymbol);
    }

    public String getClauseRep() {
        return this.clauseRep;
    }

    public Optional<Integer> getArity() {
        return this.resolvedMethodSymbol.map(methodSymbol -> methodSymbol.params().length());
    }

    public String getResolvedClauseRepWithNames() {
        if (this.conditionType.equals((Object)ContractConditionEnum.INVARIANT)) {
            return this.clauseRep;
        }
        String clauseRepWithNames = this.resolvedMethodSymbol.map(s2 -> (Name)s2.getSimpleName() + "(" + s2.params().map(p -> p.type + " " + p.name).toString(", ") + ")").orElse(this.methodName.toString());
        String declaringSymbolWithNames = this.declaringSymbol.getSimpleName() + "(" + ((Symbol.MethodSymbol)this.declaringSymbol).params().map(p -> p.type + " " + p.name).toString(", ") + ")";
        return "clause " + clauseRepWithNames + " in " + this.declaringSymbol.owner.getSimpleName() + "#" + declaringSymbolWithNames;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public Name getMethodName() {
        return this.methodName;
    }

    public ContractConditionEnum getConditionType() {
        return this.conditionType;
    }

    public boolean isResolved() {
        return this.resolvedMethodSymbol.isPresent();
    }

    public static List<ConditionClause> from(Contract.Ensures postconditionAnnotation, Symbol declaringSymbol, JavacUtils javac, JSickoContractCompilerState state) {
        return Arrays.stream(postconditionAnnotation.value()).map(clauseRep -> new ConditionClause(state, javac, declaringSymbol, (String)clauseRep, ContractConditionEnum.POSTCONDITION)).collect(List.collector());
    }

    public static List<ConditionClause> from(Contract.Requires preconditionAnnotation, Symbol declaringSymbol, JavacUtils javac, JSickoContractCompilerState state) {
        return Arrays.stream(preconditionAnnotation.value()).map(clauseRep -> new ConditionClause(state, javac, declaringSymbol, (String)clauseRep, ContractConditionEnum.PRECONDITION)).collect(List.collector());
    }

    public static List<ConditionClause> createInvariants(List<Symbol.MethodSymbol> invariants, JavacUtils javac, JSickoContractCompilerState state) {
        return invariants.stream().map(invariantSymbol -> new ConditionClause(state, javac, (Symbol.MethodSymbol)invariantSymbol)).collect(List.collector());
    }

    JCTree.JCLambda createConditionLambda(JCTree.JCVariableDecl checkerVarDef, JCTree.JCMethodDecl methodDecl) {
        Symbol ctor;
        Type stringBuilderType = this.javac.retrieveType(this.javac.javaBaseModule(), "java.lang.StringBuilder");
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(0L, this.javac.Name("$msg"), stringBuilderType, methodDecl.sym);
        JCTree.JCNewClass init = this.factory.NewClass(null, List.nil(), this.javac.Type(stringBuilderType), List.nil(), null);
        init.constructor = ctor = this.javac.retrieveEmptyConstructor(this.javac.unnamedModule(), "java.lang.StringBuilder");
        init.setType(stringBuilderType);
        JCTree.JCVariableDecl varDef = this.factory.VarDef(varSymbol, init);
        JCTree.JCIdent stringBuilderIdent = this.factory.Ident(varSymbol);
        stringBuilderIdent.type = stringBuilderType;
        stringBuilderIdent.sym = varSymbol;
        List<JCTree.JCStatement> stmts = this.createParamValuesStringExpression(checkerVarDef, stringBuilderIdent, methodDecl, List.of(this.factory.Literal(this.clauseRep + "; params: ")));
        JCTree.JCMethodInvocation binaryPlus = this.javac.MethodInvocation(this.javac.javaBaseModule(), stringBuilderIdent, this.javac.Name("toString"), List.nil());
        JCTree.JCReturn optionalOfCall = this.factory.Return(this.javac.MethodInvocation(this.javac.unnamedModule(), this.javac.Expression(this.javac.unnamedModule(), "java.util.Optional"), this.javac.Name("of"), List.of(binaryPlus)));
        List<JCTree.JCStatement> allStmts = stmts.prepend(varDef).append(optionalOfCall);
        JCTree.JCBlock ifThen = this.factory.Block(0L, allStmts);
        JCTree.JCMethodInvocation optionalEmptyCall = this.javac.MethodInvocation(this.javac.unnamedModule(), this.javac.Expression(this.javac.unnamedModule(), "java.util.Optional"), this.javac.Name("empty"));
        JCTree.JCIf lambdaBody = this.factory.If(this.createConditionCheckExpression(methodDecl), ifThen, this.factory.Return(optionalEmptyCall));
        JCTree.JCLambda lambda = this.factory.Lambda(List.nil(), this.factory.Block(0L, List.of(lambdaBody)));
        this.javac.visitLambda(lambda);
        return lambda;
    }

    private JCTree.JCExpression createConditionCheckExpression(JCTree.JCMethodDecl methodDecl) {
        TreeMaker factory = this.javac.getFactory();
        Symbol.MethodSymbol clauseSymbol = this.resolvedMethodSymbol.get();
        List resolvedVarSymbols = clauseSymbol.params().stream().map(clauseParamSymbol -> {
            Optional<Object> symbol;
            String clauseParamName = clauseParamSymbol.name.toString();
            if (clauseParamName.equals("returns")) {
                if (this.getConditionType().equals((Object)ContractConditionEnum.PRECONDITION)) {
                    symbol = Optional.empty();
                    this.state.logError(methodDecl.pos(), JSickoDiagnostic.ReturnsOnPrecondition(this));
                } else {
                    symbol = this.state.currentMethodReturnVarDecl().map(s2 -> s2.sym);
                    if (!symbol.isPresent()) {
                        this.state.logError(methodDecl.pos(), JSickoDiagnostic.ReturnsOnVoidMethod(this));
                    }
                }
            } else if (clauseParamName.equals("raises")) {
                if (this.getConditionType().equals((Object)ContractConditionEnum.PRECONDITION)) {
                    symbol = Optional.empty();
                    this.state.logError(methodDecl.pos(), JSickoDiagnostic.RaisesOnPrecondition(this));
                } else {
                    symbol = Optional.of(this.state.currentMethodRaisesVarDecl().get().sym);
                }
            } else {
                symbol = methodDecl.sym.params().stream().filter(f -> f.name.equals(clauseParamSymbol.name)).findFirst();
                if (!symbol.isPresent()) {
                    this.state.logError(methodDecl.pos(), JSickoDiagnostic.MissingParamName(clauseParamSymbol.name, this));
                }
            }
            if (symbol.isPresent() && !this.javac.isTypeAssignable((Symbol.VarSymbol)symbol.get(), (Symbol.VarSymbol)clauseParamSymbol)) {
                this.state.logError(methodDecl.pos(), JSickoDiagnostic.WrongParamType(clauseParamSymbol.name, ((Symbol.VarSymbol)symbol.get()).type, clauseParamSymbol.type, this));
                symbol = Optional.empty();
            }
            return symbol;
        }).collect(List.collector());
        if (resolvedVarSymbols.stream().anyMatch(o -> !o.isPresent())) {
            return this.javac.falseLiteral();
        }
        List args = resolvedVarSymbols.stream().map(o -> (Symbol.VarSymbol)o.get()).map(symbol -> {
            JCTree.JCIdent ident = factory.Ident((Symbol)symbol);
            ident.setType(symbol.type);
            ident.sym = symbol;
            return ident;
        }).collect(List.collector());
        JCTree.JCIdent ident = factory.Ident(this.resolvedMethodSymbol.get());
        ident.setType(this.resolvedMethodSymbol.get().type);
        ident.sym = this.resolvedMethodSymbol.get();
        JCTree.JCMethodInvocation call = factory.App(ident, List.from(args.toArray(new JCTree.JCExpression[0])));
        JCTree.JCUnary unaryOp = factory.Unary(JCTree.Tag.NOT, call);
        this.javac.setOperator(unaryOp);
        JCTree.JCExpression potentiallyNegatedCall = this.isNegated() ? call : unaryOp;
        JCTree.JCParens result = factory.Parens(potentiallyNegatedCall);
        result.setType(this.javac.booleanType());
        return result;
    }

    private List<JCTree.JCStatement> createParamValuesStringExpression(JCTree.JCVariableDecl checkerVarDef, JCTree.JCIdent stringBuilderIdent, JCTree.JCMethodDecl methodDecl, List<JCTree.JCExpression> prefix) {
        TreeMaker factory = this.javac.getFactory();
        Symbol.MethodSymbol clauseSymbol = this.resolvedMethodSymbol.get();
        List thisExpression = !methodDecl.sym.isStatic() ? List.of(factory.Literal("this: "), factory.This(methodDecl.sym.owner.type), factory.Literal(", ")) : List.nil();
        List resolvedVarSymbols = clauseSymbol.params().stream().map(clauseParamSymbol -> {
            Optional<Symbol.VarSymbol> symbol;
            String clauseParamName = clauseParamSymbol.name.toString();
            if (clauseParamName.equals("returns")) {
                symbol = this.state.currentMethodReturnVarDecl().map(s2 -> s2.sym);
                if (!symbol.isPresent()) {
                    this.state.logError(methodDecl.pos(), JSickoDiagnostic.ReturnsOnVoidMethod(this));
                }
            } else if (clauseParamName.equals("raises")) {
                symbol = Optional.of(this.state.currentMethodRaisesVarDecl().get().sym);
            } else {
                symbol = methodDecl.sym.params().stream().filter(f -> f.name.equals(clauseParamSymbol.name)).findFirst();
                if (!symbol.isPresent()) {
                    this.state.logError(methodDecl.pos(), JSickoDiagnostic.MissingParamName(clauseParamSymbol.name, this));
                }
            }
            return symbol;
        }).collect(List.collector());
        if (resolvedVarSymbols.stream().anyMatch(o -> !o.isPresent())) {
            return List.nil();
        }
        List args = resolvedVarSymbols.stream().map(o -> (Symbol.VarSymbol)o.get()).flatMap(symbol -> {
            JCTree.JCIdent clauseParamIdent = factory.Ident((Symbol)symbol);
            clauseParamIdent.setType(symbol.type);
            clauseParamIdent.sym = symbol;
            return Stream.of(factory.Literal(symbol.name + ": "), clauseParamIdent, factory.Literal(", "));
        }).collect(List.collector()).prependList(thisExpression);
        List<JCTree.JCExpression> stringElems = args.prepend(factory.Literal("[")).take(args.size() > 1 ? args.size() : args.size() + 1).append(factory.Literal("]")).prependList(prefix);
        List reducedLiterals = stringElems.stream().reduce(List.nil(), (l, e) -> {
            if (l.isEmpty()) {
                return l.prepend(e);
            }
            JCTree.JCExpression head = (JCTree.JCExpression)l.head;
            if (head instanceof JCTree.JCLiteral && e instanceof JCTree.JCLiteral) {
                return l.tail.prepend(factory.Literal((String)((JCTree.JCLiteral)head).value + ((JCTree.JCLiteral)e).value));
            }
            return l.prepend(e);
        }, (l1, l2) -> l1.appendList(l2)).reverse();
        List<JCTree.JCStatement> sum = reducedLiterals.stream().flatMap(elem -> {
            JCTree.JCExpression arg = elem;
            if (!elem.type.toString().equals(this.javac.stringType().toString())) {
                arg = elem.type instanceof Type.ArrayType ? this.javac.MethodInvocation(this.javac.javaBaseModule(), this.javac.Type(this.javac.retrieveType(this.javac.javaBaseModule(), "java.util.Arrays")), this.javac.Name("toString"), List.of(elem)) : this.javac.MethodInvocation(this.javac.javaBaseModule(), this.javac.Type(this.javac.stringType()), this.javac.Name("valueOf"), List.of(elem));
                JCTree.JCStatement disableChecker = this.javac.MethodCall(this.javac.unnamedModule(), factory.Ident(checkerVarDef), this.javac.Name("disableObjects"), List.of(elem));
                JCTree.JCStatement enableChecker = this.javac.MethodCall(this.javac.unnamedModule(), factory.Ident(checkerVarDef), this.javac.Name("enableObjects"), List.of(elem));
                JCTree.JCStatement append = this.javac.MethodCall(this.javac.javaBaseModule(), stringBuilderIdent, this.javac.Name("append"), List.of(arg));
                return Stream.of(disableChecker, append, enableChecker);
            }
            JCTree.JCStatement append = this.javac.MethodCall(this.javac.javaBaseModule(), stringBuilderIdent, this.javac.Name("append"), List.of(arg));
            return Stream.of(append);
        }).collect(List.collector());
        return sum;
    }

    List<JSickoDiagnostic.JSickoError> resolveContractMethod(JCTree.JCClassDecl classDecl) {
        Symbol.MethodSymbol resolvedMethod;
        Type classType = classDecl.sym.type;
        List<Type> closure = this.javac.typeClosure(classType);
        Optional optionalContractMethod = closure.stream().flatMap(closureElem -> closureElem.asElement().getEnclosedElements().stream().filter(contractElement -> contractElement.name.equals(this.methodName)).map(contractElement -> (Symbol.MethodSymbol)contractElement)).findFirst();
        if (optionalContractMethod.isPresent() && (resolvedMethod = (Symbol.MethodSymbol)optionalContractMethod.get()).getReturnType() != null && !resolvedMethod.getReturnType().equals(this.javac.booleanType())) {
            return List.of(JSickoDiagnostic.ClauseIsNotBoolean(this, resolvedMethod));
        }
        if (optionalContractMethod.isEmpty()) {
            return List.of(JSickoDiagnostic.MissingClause(this));
        }
        this.resolvedMethodSymbol = optionalContractMethod;
        return List.nil();
    }

    public boolean isClauseMethodStatic() {
        if (!this.isResolved()) {
            throw new IllegalStateException("Contract method not resolved yet");
        }
        Symbol.MethodSymbol clauseMethod = this.resolvedMethodSymbol.get();
        return clauseMethod.getModifiers().contains((Object)Modifier.STATIC);
    }

    public String toString() {
        return this.conditionType + " " + this.clauseRep;
    }
}

