/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.codelounge.jsicko.plugin;

import ch.usi.si.codelounge.jsicko.Contract;
import ch.usi.si.codelounge.jsicko.plugin.ConditionClause;
import ch.usi.si.codelounge.jsicko.plugin.ContractConditionEnum;
import ch.usi.si.codelounge.jsicko.plugin.JSickoContractCompilerState;
import ch.usi.si.codelounge.jsicko.plugin.OldValuesTable;
import ch.usi.si.codelounge.jsicko.plugin.diagnostics.JSickoDiagnostic;
import ch.usi.si.codelounge.jsicko.plugin.utils.ConditionChecker;
import ch.usi.si.codelounge.jsicko.plugin.utils.JavacUtils;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import java.util.Arrays;
import java.util.Deque;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.lang.model.element.Modifier;

class ContractCompilerTreeScanner
extends TreeScanner<Void, Deque<Tree>> {
    private final JavacUtils javac;
    private final JSickoContractCompilerState state;
    private final TreeMaker factory;

    ContractCompilerTreeScanner(BasicJavacTask task) {
        this.javac = new JavacUtils(task);
        this.state = new JSickoContractCompilerState(task);
        this.factory = this.javac.getFactory();
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree node, Deque<Tree> relevantScope) {
        this.state.enterCompilationUnit((JCTree.JCCompilationUnit)node);
        Void w = (Void)super.visitCompilationUnit(node, relevantScope);
        this.state.exitCompilationUnit();
        return w;
    }

    @Override
    public Void visitClass(ClassTree classTree, Deque<Tree> relevantScope) {
        JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)classTree;
        this.state.currentCompilationUnitTree().ifPresent(currentCompilationUnitTree -> {
            this.state.enterClassDecl(classDecl);
            this.optionalDeclareOldVariableAndMethod();
        });
        Void w = (Void)super.visitClass(classTree, relevantScope);
        this.state.exitClassDecl();
        this.state.logNote(classDecl.pos(), JSickoDiagnostic.InstrumentedClassNote(classDecl));
        return w;
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Deque<Tree> relevantScope) {
        JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)methodTree;
        this.checkAnnotations(methodDecl);
        this.state.enterMethodDecl(methodDecl);
        if (this.state.currentMethodShouldBeInstrumented()) {
            List<List<ConditionClause>> classInvariants = List.of(this.state.classInvariants());
            List<Symbol> overriddenMethods = this.state.findOverriddenMethodsOfCurrentMethod();
            if (overriddenMethods.size() > 0) {
                List<List<ConditionClause>> requireClausesByMethod = this.constructRequireClausesByMethod(overriddenMethods);
                List<ConditionClause> ensuresClauses = this.constructEnsureClauses(overriddenMethods);
                boolean isMarkedPure = this.isAnyMethodMarkedAsOrMustBePure(overriddenMethods);
                this.declareRaisesValueCatcher();
                JCTree.JCTry tryBlock = this.boxMethodBody();
                this.optionalDeclareReturnValueCatcher();
                this.appendRaisesValueCatcher();
                this.addOldValuesTableInstrumentation(isMarkedPure, tryBlock);
                this.addConditions(ContractConditionEnum.PRECONDITION, methodDecl.body, isMarkedPure, requireClausesByMethod);
                this.addConditions(ContractConditionEnum.POSTCONDITION, tryBlock.finalizer, isMarkedPure, List.of(ensuresClauses));
                this.addConditions(ContractConditionEnum.INVARIANT, tryBlock.finalizer, isMarkedPure, classInvariants);
            }
        }
        relevantScope.push(methodTree);
        Void w = (Void)super.visitMethod(methodTree, relevantScope);
        relevantScope.pop();
        this.state.exitMethodDecl();
        return w;
    }

    private void checkAnnotations(JCTree.JCMethodDecl methodDecl) {
        Contract.Invariant invariantAnnotation = methodDecl.sym.getAnnotation(Contract.Invariant.class);
        if (invariantAnnotation != null) {
            if (((List)methodDecl.getParameters()).length() > 0) {
                this.state.logError(methodDecl.pos(), JSickoDiagnostic.InvariantHasNonZeroArity(methodDecl));
            }
            if (methodDecl.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                this.state.logError(methodDecl.pos(), JSickoDiagnostic.InvariantIsStatic(methodDecl));
            }
            if (methodDecl.getReturnType().type != null && !methodDecl.getReturnType().type.equals(this.javac.booleanType())) {
                this.state.logError(methodDecl.pos(), JSickoDiagnostic.InvariantIsNotBoolean(methodDecl));
            }
        }
    }

    private List<ConditionClause> constructEnsureClauses(List<Symbol> overriddenMethods) {
        return overriddenMethods.stream().flatMap(overriddenMethod -> Arrays.stream((Contract.Ensures[])overriddenMethod.getAnnotationsByType(Contract.Ensures.class)).flatMap(ensuresClauseGroup -> ConditionClause.from(ensuresClauseGroup, overriddenMethod, this.javac, this.state).stream())).collect(List.collector());
    }

    private List<List<ConditionClause>> constructRequireClausesByMethod(List<Symbol> overriddenMethods) {
        return overriddenMethods.stream().flatMap(overriddenMethod -> Arrays.stream((Contract.Requires[])overriddenMethod.getAnnotationsByType(Contract.Requires.class)).map(requiresClauseGroup -> ConditionClause.from(requiresClauseGroup, overriddenMethod, this.javac, this.state))).collect(List.collector());
    }

    private boolean isAnyMethodMarkedAsOrMustBePure(List<Symbol> methodSymbols) {
        return methodSymbols.stream().anyMatch(this::isMarkedAsPureOrIsSpecialPureMethod);
    }

    private boolean isMarkedAsPureOrIsSpecialPureMethod(Symbol symbol) {
        return this.isMarkedAsPure(symbol) || this.isSpecialPureMethod(symbol);
    }

    private boolean isMarkedAsPure(Symbol symbol) {
        return ((Contract.Pure[])symbol.getAnnotationsByType(Contract.Pure.class)).length > 0;
    }

    private boolean isSpecialPureMethod(Symbol symbol) {
        return symbol.equals(this.javac.getJavaUtilCollectionIteratorMethodSymbol());
    }

    private void addOldValuesTableInstrumentation(boolean isMarkedPure, JCTree.JCTry tryBlock) {
        this.state.ifMethodDeclPresent(methodDecl -> {
            if (!methodDecl.sym.isConstructor() && !isMarkedPure) {
                this.optionalSaveOldState();
                this.addEnterScopeStatement();
                this.addLeaveScopeStatement(tryBlock.finalizer);
            }
        });
    }

    private void addEnterScopeStatement() {
        this.state.ifMethodDeclPresent(methodDecl -> this.state.optionalOldValuesTableField().ifPresent(oldValuesTableField -> {
            JCTree.JCMethodInvocation enterScopeStatement = this.buildEnterScopeStatement(methodDecl.sym);
            methodDecl.getBody().stats = methodDecl.getBody().stats.prepend(this.factory.Exec(enterScopeStatement));
        }));
    }

    private void addLeaveScopeStatement(JCTree.JCBlock finalizer) {
        JCTree.JCMethodInvocation leaveScopeStatement = this.buildLeaveScopeStatement();
        finalizer.stats = finalizer.stats.prepend(this.factory.Exec(leaveScopeStatement));
    }

    private void optionalSaveOldState() {
        this.state.ifMethodDeclPresent(methodDecl -> this.state.optionalOldValuesTableField().ifPresent(oldValuesTableField -> {
            JCTree.JCVariableDecl oldValuesTableFieldDecl = this.state.oldValuesTableFieldDeclByMethodType();
            if (!methodDecl.sym.isStatic()) {
                JCTree.JCStatement saveThisOldValueStatement = this.buildStatementToSaveThisOldValue(oldValuesTableFieldDecl);
                methodDecl.getBody().stats = methodDecl.getBody().stats.prepend(saveThisOldValueStatement);
            }
            List saveLocalVariableOldValueStatements = methodDecl.getParameters().stream().map(paramDecl -> this.buildStatementToSaveLocalVariableOldValue(oldValuesTableFieldDecl, (JCTree.JCVariableDecl)paramDecl)).collect(List.collector());
            methodDecl.getBody().stats = methodDecl.getBody().stats.prependList(saveLocalVariableOldValueStatements);
        }));
    }

    private JCTree.JCStatement buildStatementToSaveLocalVariableOldValue(JCTree.JCVariableDecl oldValuesTableFieldDecl, JCTree.JCVariableDecl paramDecl) {
        JCTree.JCIdent paramIdent = this.factory.Ident(paramDecl.sym);
        paramIdent.setType(paramDecl.type);
        paramIdent.sym = paramDecl.sym;
        JCTree.JCMethodInvocation paramCloneCall = this.javac.MethodInvocation(this.javac.unnamedModule(), this.javac.Expression(this.javac.unnamedModule(), "ch.usi.si.codelounge.jsicko.plugin.utils.CloneUtils"), this.javac.Name("kryoClone"), List.of(paramIdent));
        JCTree.JCLiteral nameLiteral = this.factory.Literal(paramDecl.getName().toString());
        List<JCTree.JCExpression> mapSetParams = List.of(nameLiteral, paramCloneCall);
        JCTree.JCIdent oldValuesTableIdent = this.factory.Ident(oldValuesTableFieldDecl.sym);
        oldValuesTableIdent.setType(oldValuesTableFieldDecl.type);
        oldValuesTableIdent.sym = oldValuesTableFieldDecl.sym;
        return this.javac.MethodCall(this.javac.unnamedModule(), oldValuesTableIdent, this.javac.Name("putValue"), mapSetParams);
    }

    private JCTree.JCStatement buildStatementToSaveThisOldValue(JCTree.JCVariableDecl oldValuesTableFieldDecl) {
        return this.state.mapAndGetOnClassDecl(classDecl -> {
            JCTree.JCExpression thisType = this.factory.This(classDecl.sym.type);
            JCTree.JCMethodInvocation cloneCall = this.javac.MethodInvocation(this.javac.unnamedModule(), this.javac.Expression(this.javac.unnamedModule(), "ch.usi.si.codelounge.jsicko.plugin.utils.CloneUtils"), this.javac.Name("kryoClone"), List.of(thisType));
            JCTree.JCLiteral literal = this.factory.Literal("this");
            List<JCTree.JCExpression> params = List.of(literal, cloneCall);
            JCTree.JCIdent oldValuesTableIdent = this.factory.Ident(oldValuesTableFieldDecl.sym);
            oldValuesTableIdent.setType(oldValuesTableFieldDecl.type);
            return this.javac.MethodCall(this.javac.unnamedModule(), oldValuesTableIdent, this.javac.Name("putValue"), params);
        });
    }

    private JCTree.JCMethodInvocation buildEnterScopeStatement(Symbol.MethodSymbol methodSymbol) {
        List<JCTree.JCExpression> enterParams = List.of(this.factory.Literal(methodSymbol.toString()));
        JCTree.JCVariableDecl oldValuesTableField = this.state.oldValuesTableFieldDeclByMethodType();
        JCTree.JCIdent oldValuesTableIdent = this.factory.Ident(oldValuesTableField.sym);
        oldValuesTableIdent.setType(oldValuesTableField.type);
        return this.javac.MethodInvocation(this.javac.unnamedModule(), oldValuesTableIdent, this.javac.Name("enter"), enterParams);
    }

    private JCTree.JCMethodInvocation buildLeaveScopeStatement() {
        JCTree.JCVariableDecl oldValuesTableField = this.state.oldValuesTableFieldDeclByMethodType();
        JCTree.JCIdent oldValuesTableIdent = this.factory.Ident(oldValuesTableField.sym);
        oldValuesTableIdent.setType(oldValuesTableField.type);
        return this.javac.MethodInvocation(this.javac.unnamedModule(), oldValuesTableIdent, this.javac.Name("leave"));
    }

    private void optionalDeclareOldVariableAndMethod() {
        this.state.ifClassDeclPresent(classDecl -> {
            if (this.state.currentClassHasContract() && !this.state.optionalOldValuesTableField().isPresent()) {
                Symbol ctor;
                JCTree.JCVariableDecl oldField = this.declareOldValuesTableField(false);
                if (this.state.currentClassCanHaveStaticDecls()) {
                    this.declareOldValuesTableField(true);
                }
                Type.TypeVar typeVar = this.javac.freshObjectTypeVar(null);
                Type.MethodType baseType = new Type.MethodType(List.of(this.javac.stringType(), typeVar), typeVar, List.nil(), classDecl.sym);
                Type.ForAll overriddenOldMethodType = new Type.ForAll(List.of(typeVar), (Type)baseType);
                Symbol.MethodSymbol overriddenOldMethodSymbol = new Symbol.MethodSymbol(1L, this.javac.Name("instanceOld"), overriddenOldMethodType, classDecl.sym);
                this.state.setCurrentOldMethodSymbol(overriddenOldMethodSymbol);
                Symbol.VarSymbol x0VarSymbol = new Symbol.VarSymbol(0x200000000L, this.javac.Name("x0"), this.javac.stringType(), overriddenOldMethodSymbol);
                x0VarSymbol.adr = 1;
                JCTree.JCIdent literal = this.factory.Ident(x0VarSymbol);
                literal.type = this.javac.stringType();
                literal.sym = x0VarSymbol;
                List<JCTree.JCExpression> params = List.of(literal);
                JCTree.JCIdent oldFieldIdent = this.factory.Ident(oldField.sym);
                oldFieldIdent.type = oldField.type;
                oldFieldIdent.sym = oldField.sym;
                JCTree.JCMethodInvocation getCall = this.javac.MethodInvocation(this.javac.unnamedModule(), oldFieldIdent, this.javac.Name("getValue"), params);
                JCTree.JCTypeCast castCall = this.factory.TypeCast(typeVar.tsym.type, (JCTree.JCExpression)getCall);
                JCTree.JCReturn returnElemStatement = this.factory.Return(castCall);
                JCTree.JCUnary checkCall = this.factory.Unary(JCTree.Tag.NOT, this.javac.MethodInvocation(this.javac.unnamedModule(), oldFieldIdent, this.javac.Name("containsKey"), params));
                this.javac.setOperator(checkCall);
                Type runtimeExceptionType = this.javac.runtimeExceptionType();
                JCTree.JCLiteral msg = this.factory.Literal("[jsicko] values table does not contain key: clause uses old(.) in a pure method");
                msg.setType(this.javac.stringType());
                JCTree.JCNewClass init = this.factory.NewClass(null, List.nil(), this.javac.Type(runtimeExceptionType), List.of(msg), null);
                init.constructor = ctor = this.javac.retrieveConstructor(this.javac.unnamedModule(), "java.lang.RuntimeException", this.javac.stringType());
                init.setType(runtimeExceptionType);
                JCTree.JCThrow throwStatement = this.factory.Throw(init);
                JCTree.JCIf checkValueIsDefined = this.factory.If(checkCall, this.factory.Block(0L, List.of(throwStatement)), this.factory.Block(0L, List.of(returnElemStatement)));
                JCTree.JCBlock overriddenOldMethodBody = this.factory.Block(0L, List.of(checkValueIsDefined));
                JCTree.JCMethodDecl overriddenOldMethod = this.factory.MethodDef(overriddenOldMethodSymbol, overriddenOldMethodBody);
                ((JCTree.JCVariableDecl)overriddenOldMethod.params.head).sym.adr = 0;
                overriddenOldMethod.params.last().sym.adr = 1;
                this.state.overrideOldMethod(overriddenOldMethod);
            }
        });
    }

    private JCTree.JCVariableDecl declareOldValuesTableField(boolean declareTheStaticOne) {
        return this.state.mapAndGetOnClassDecl(classDecl -> {
            int flags = (declareTheStaticOne ? 9 : 2) | 0x10;
            String fieldName = declareTheStaticOne ? "$staticOldValuesTable" : "$oldValuesTable";
            JCTree.JCNewClass init = this.factory.NewClass(null, List.nil(), this.javac.oldValuesTableTypeExpression(), List.nil(), null);
            init.constructor = this.javac.retrieveConstructor(this.javac.unnamedModule(), OldValuesTable.class.getCanonicalName());
            init.setType(this.javac.oldValuesTableTypeExpression().type);
            Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(flags, this.javac.Name(fieldName), this.javac.oldValuesTableClassType(), classDecl.sym);
            JCTree.JCVariableDecl varDef = this.factory.VarDef(varSymbol, init);
            this.state.appendOldValuesTableField(varDef, declareTheStaticOne);
            return varDef;
        });
    }

    private JCTree.JCTry boxMethodBody() {
        return this.state.mapAndGetOnMethodDecl(methodDecl -> {
            JCTree.JCTry tryBlock;
            JCTree.JCBlock body = methodDecl.getBody();
            Symbol.MethodSymbol methodSymbol = methodDecl.sym;
            JCTree.JCBlock finallyBlock = this.factory.Block(0L, List.nil());
            List<JCTree.JCCatch> catchBlock = this.buildCatchBlock();
            if (methodSymbol.isConstructor() && this.javac.isSuperOrThisConstructorCall((JCTree.JCStatement)body.stats.head)) {
                JCTree.JCStatement firstStatement = (JCTree.JCStatement)body.stats.head;
                List<JCTree.JCStatement> rest = body.stats.tail;
                tryBlock = this.factory.Try(this.factory.Block(0L, rest), catchBlock, finallyBlock);
                body.stats = List.of(tryBlock).prepend((JCTree.JCTry)firstStatement);
            } else {
                tryBlock = this.factory.Try(this.factory.Block(0L, body.stats), catchBlock, finallyBlock);
                body.stats = List.of(tryBlock);
            }
            return tryBlock;
        });
    }

    private List<JCTree.JCCatch> buildCatchBlock() {
        return this.state.mapAndGetOnMethodDecl(methodDecl -> {
            if (this.state.currentMethodRaisesVarDecl().isPresent()) {
                Type exceptionType = this.javac.deriveMostGeneralExceptionTypeThrown((List<JCTree.JCExpression>)methodDecl.getThrows());
                Symbol.VarSymbol exceptionVarSymbol = new Symbol.VarSymbol(0x20000000000L, this.javac.Name("$thrown"), exceptionType, methodDecl.sym);
                JCTree.JCVariableDecl exceptionVariableDecl = this.factory.VarDef(exceptionVarSymbol, null);
                exceptionVarSymbol.adr = 0;
                JCTree.JCIdent ident = this.factory.Ident(this.javac.Name("$thrown"));
                ident.setType(exceptionType);
                ident.sym = exceptionVarSymbol;
                JCTree.JCThrow rethrowStatement = this.factory.Throw(ident);
                JCTree.JCIdent raisesIdent = this.factory.Ident(this.javac.Name("$raises"));
                raisesIdent.type = this.state.currentMethodRaisesVarDecl().get().sym.type;
                raisesIdent.sym = this.state.currentMethodRaisesVarDecl().get().sym;
                JCTree.JCExpressionStatement assignmentToRaises = this.factory.Exec(this.factory.Assign(raisesIdent, ident));
                JCTree.JCBlock block = this.factory.Block(0L, List.of(assignmentToRaises, rethrowStatement));
                JCTree.JCCatch exceptionHandler = this.factory.Catch(exceptionVariableDecl, block);
                return List.of(exceptionHandler);
            }
            return List.nil();
        });
    }

    private void optionalDeclareReturnValueCatcher() {
        this.state.ifMethodDeclPresent(methodDecl -> {
            JCTree.JCBlock body = methodDecl.getBody();
            if (!methodDecl.sym.isConstructor() && !this.javac.hasVoidReturnType((JCTree.JCMethodDecl)methodDecl)) {
                JCTree.JCLiteral zeroValue = this.javac.zeroValue(methodDecl.getReturnType().type);
                zeroValue.type = this.javac.zeroType(methodDecl.getReturnType().type);
                Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(0x200000010L, this.javac.Name("$returns"), methodDecl.getReturnType().type, methodDecl.sym);
                JCTree.JCVariableDecl varDef = this.factory.VarDef(varSymbol, zeroValue);
                body.stats = body.stats.prepend(varDef);
                this.state.setCurrentMethodReturnVarDecl(varDef);
            }
        });
    }

    private void declareRaisesValueCatcher() {
        this.state.ifMethodDeclPresent(methodDecl -> {
            JCTree.JCLiteral zeroValue = this.javac.nullLiteral();
            zeroValue.type = this.javac.botType();
            Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(0L, this.javac.Name("$raises"), this.javac.retrieveType(this.javac.javaBaseModule(), Throwable.class.getCanonicalName()), methodDecl.sym);
            JCTree.JCVariableDecl varDef = this.factory.VarDef(varSymbol, zeroValue);
            varDef.setType(this.javac.throwableType());
            varDef.sym = varSymbol;
            this.state.setCurrentMethodRaisesVarDecl(varDef);
        });
    }

    private void appendRaisesValueCatcher() {
        this.state.ifMethodDeclPresent(methodDecl -> {
            if (this.state.currentMethodRaisesVarDecl().isPresent()) {
                JCTree.JCBlock body = methodDecl.getBody();
                JCTree.JCVariableDecl varDef = this.state.currentMethodRaisesVarDecl().get();
                body.stats = this.javac.isSuperOrThisConstructorCall((JCTree.JCStatement)body.stats.head) ? body.stats.tail.prepend(varDef).prepend((JCTree.JCVariableDecl)((JCTree.JCStatement)body.stats.head)) : body.stats.prepend(varDef);
            }
        });
    }

    private void addConditions(ContractConditionEnum conditionType, JCTree.JCBlock block, boolean isMarkedPure, List<List<ConditionClause>> groupedClauses) {
        this.state.ifMethodDeclPresent(methodDecl -> {
            if (this.shouldAddConditions(conditionType, (JCTree.JCMethodDecl)methodDecl, isMarkedPure, groupedClauses)) {
                if (groupedClauses.size() > 0) {
                    this.state.logNote(methodDecl.pos(), JSickoDiagnostic.ConditionCheckNote(methodDecl.sym, conditionType, groupedClauses));
                }
                this.buildConditionsChecker(conditionType, (JCTree.JCMethodDecl)methodDecl, block, groupedClauses);
            }
        });
    }

    private boolean shouldAddConditions(ContractConditionEnum conditionType, JCTree.JCMethodDecl methodDecl, boolean isMarkedPure, List<List<ConditionClause>> groupedClauses) {
        BooleanSupplier defaultCheck = () -> groupedClauses.size() > 0 && groupedClauses.stream().allMatch(clause -> clause.size() > 0);
        if (conditionType == ContractConditionEnum.INVARIANT) {
            return !isMarkedPure && !methodDecl.sym.isStatic() && defaultCheck.getAsBoolean();
        }
        return defaultCheck.getAsBoolean();
    }

    private void buildConditionsChecker(ContractConditionEnum conditionType, JCTree.JCMethodDecl methodDecl, JCTree.JCBlock block, List<List<ConditionClause>> conditionGroups) {
        if (conditionGroups.size() > 0) {
            JCTree.JCVariableDecl checkerVarDef = this.createCheckerDeclaration(conditionType, methodDecl.sym);
            List<JCTree.JCStatement> lambdaCalls = this.buildLambdaCalls(methodDecl, checkerVarDef, conditionGroups);
            JCTree.JCStatement checkCall = this.buildCheckStatement(methodDecl.sym.owner.type, methodDecl.getModifiers().getFlags().contains((Object)Modifier.STATIC), checkerVarDef);
            List<JCTree.JCStatement> conditionBlock = lambdaCalls.prepend(checkerVarDef).append(checkCall);
            block.stats = this.javac.isSuperOrThisConstructorCall((JCTree.JCStatement)block.stats.head) ? block.stats.tail.prependList(conditionBlock).prepend((JCTree.JCStatement)block.stats.head) : block.stats.prependList(conditionBlock);
        }
    }

    private JCTree.JCVariableDecl createCheckerDeclaration(ContractConditionEnum conditionType, Symbol.MethodSymbol owner) {
        String lowerCaseConditionTypeName = conditionType.name().toLowerCase();
        String checkerConstructorMethodName = "new" + conditionType.toString() + "Checker";
        Symbol.VarSymbol checkerVarSymbol = new Symbol.VarSymbol(0L, this.javac.Name(lowerCaseConditionTypeName + "Checker"), this.javac.preconditionCheckerType(), owner);
        JCTree.JCVariableDecl checkerVar = this.factory.VarDef(checkerVarSymbol, this.javac.MethodInvocation(this.javac.unnamedModule(), this.javac.Expression(this.javac.unnamedModule(), ConditionChecker.class.getCanonicalName()), this.javac.Name(checkerConstructorMethodName)));
        checkerVar.setType(this.javac.retrieveType(this.javac.unnamedModule(), ConditionChecker.class.getCanonicalName()));
        return checkerVar;
    }

    private List<JCTree.JCStatement> buildLambdaCalls(JCTree.JCMethodDecl methodDecl, JCTree.JCVariableDecl checkerVarDef, List<List<ConditionClause>> conditionGroups) {
        boolean isMethodStatic = methodDecl.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        boolean allResolved = conditionGroups.stream().allMatch(conditionGroup -> conditionGroup.stream().allMatch(clause -> {
            List<JSickoDiagnostic.JSickoError> errors = clause.resolveContractMethod(this.state.currentClassDecl().get());
            if (errors.nonEmpty()) {
                errors.forEach(error -> this.state.logError(methodDecl.pos(), (JSickoDiagnostic.JSickoError)error));
                return false;
            }
            if (isMethodStatic && !clause.isClauseMethodStatic()) {
                this.state.logError(methodDecl.pos(), JSickoDiagnostic.IncompatibleClause(clause, isMethodStatic, methodDecl.getName()));
            }
            return true;
        }));
        if (!allResolved) {
            return List.nil();
        }
        return conditionGroups.stream().map(conditionGroup -> {
            List<JCTree.JCExpression> lambdas = conditionGroup.stream().map(clause -> clause.createConditionLambda(checkerVarDef, methodDecl)).collect(List.collector());
            return this.javac.MethodCall(this.javac.unnamedModule(), this.factory.Ident(checkerVarDef), this.javac.Name("addConditionGroup"), lambdas);
        }).collect(List.collector());
    }

    private JCTree.JCStatement buildCheckStatement(Type thisType, boolean isStatic, JCTree.JCVariableDecl checkerVarDef) {
        if (isStatic) {
            return this.javac.MethodCall(this.javac.unnamedModule(), this.factory.Ident(checkerVarDef), this.javac.Name("check"), List.nil());
        }
        JCTree.JCExpression arg = this.factory.This(thisType);
        arg.setType(this.javac.objectType());
        return this.javac.MethodCall(this.javac.unnamedModule(), this.factory.Ident(checkerVarDef), this.javac.Name("check"), List.of(arg));
    }

    @Override
    public Void visitReturn(ReturnTree node, Deque<Tree> relevantScope) {
        JCTree.JCReturn returnNode = (JCTree.JCReturn)node;
        this.state.currentMethodReturnVarDecl().ifPresent(varDecl -> {
            if (this.state.isCurrentMethodDecl((Tree)relevantScope.peek())) {
                JCTree.JCIdent returnIdent = this.factory.Ident(this.javac.Name("$returns"));
                returnIdent.type = this.state.currentMethodReturnVarDecl().get().sym.type;
                returnIdent.sym = this.state.currentMethodReturnVarDecl().get().sym;
                returnNode.expr = this.factory.Assign(returnIdent, returnNode.expr);
            }
        });
        return (Void)super.visitReturn(node, relevantScope);
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree node, Deque<Tree> relevantScope) {
        relevantScope.push(node);
        Void v = (Void)super.visitLambdaExpression(node, relevantScope);
        relevantScope.pop();
        return v;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Deque<Tree> relevantScope) {
        Void w = (Void)super.visitMethodInvocation(node, relevantScope);
        JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)node;
        boolean isScopeInStaticMethod = this.isScopeInStaticMethod(relevantScope);
        if (this.isScopeInPureMethod(relevantScope) && methodInvocation.meth.toString().equals("old")) {
            String paramName = ((JCTree.JCExpression)methodInvocation.args.head).toString();
            if (isScopeInStaticMethod) {
                JCTree.JCMethodInvocation mc = this.javac.MethodInvocation(this.javac.unnamedModule(), this.javac.Expression(this.javac.unnamedModule(), Contract.class.getCanonicalName()), this.javac.Name("staticOld"));
                methodInvocation.meth = mc.meth;
                methodInvocation.args = methodInvocation.args.prepend(this.factory.Literal(paramName));
                methodInvocation.args = methodInvocation.args.prepend(this.factory.ClassLiteral(this.getLastMethodInScope(relevantScope).get().sym.enclClass()));
            } else {
                JCTree.JCIdent oldIdent = this.factory.Ident(this.javac.Name("instanceOld"));
                if (this.state.currentOldMethodSymbol().isPresent()) {
                    oldIdent.sym = this.state.currentOldMethodSymbol().get();
                    oldIdent.type = this.state.currentOldMethodSymbol().get().type;
                } else {
                    oldIdent.sym = this.javac.retrieveMemberFromClassByName(this.javac.unnamedModule(), Contract.class.getCanonicalName(), "instanceOld").get();
                    oldIdent.type = oldIdent.sym.type;
                }
                methodInvocation.meth = oldIdent;
                methodInvocation.args = methodInvocation.args.prepend(this.factory.Literal(paramName));
            }
        }
        return w;
    }

    private boolean isScopeInStaticMethod(Deque<Tree> relevantScope) {
        Optional<JCTree.JCMethodDecl> optionalLastMethod = this.getLastMethodInScope(relevantScope);
        return optionalLastMethod.isPresent() && optionalLastMethod.get().sym.isStatic();
    }

    private boolean isScopeInPureMethod(Deque<Tree> relevantScope) {
        Optional<JCTree.JCMethodDecl> optionalLastMethod = this.getLastMethodInScope(relevantScope);
        return optionalLastMethod.isPresent() && this.isMarkedAsPureOrIsSpecialPureMethod(optionalLastMethod.get().sym);
    }

    private Optional<JCTree.JCMethodDecl> getLastMethodInScope(Deque<Tree> relevantScope) {
        Optional<Tree> optionalLastMethod = relevantScope.stream().dropWhile(t -> !(t instanceof JCTree.JCMethodDecl)).findFirst();
        return optionalLastMethod.map(JCTree.JCMethodDecl.class::cast);
    }
}

