/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.codelounge.jsicko.plugin;

import ch.usi.si.codelounge.jsicko.Contract;
import ch.usi.si.codelounge.jsicko.plugin.ConditionClause;
import ch.usi.si.codelounge.jsicko.plugin.diagnostics.JSickoDiagnostic;
import ch.usi.si.codelounge.jsicko.plugin.utils.JavacUtils;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.lang.model.element.Modifier;

class JSickoContractCompilerState {
    private final JavacUtils javac;
    private final LinkedList<InternalState> stack;
    Optional<JCTree.JCCompilationUnit> _currentCompilationUnitTree = Optional.empty();

    JSickoContractCompilerState(BasicJavacTask task) {
        this.javac = new JavacUtils(task);
        this.stack = new LinkedList();
    }

    private InternalState curr() {
        return this.stack.peekLast();
    }

    public boolean currentClassHasContract() {
        return !this.stack.isEmpty() && this.curr()._currentClassHasContract;
    }

    public boolean currentClassCanHaveStaticDecls() {
        return !this.stack.isEmpty() && this.curr()._currentClassDecl.isPresent() && !this.curr()._currentClassDecl.get().sym.isInner();
    }

    void enterCompilationUnit(JCTree.JCCompilationUnit compilationUnitTree) {
        this._currentCompilationUnitTree = Optional.of(compilationUnitTree);
    }

    void exitCompilationUnit() {
        this._currentCompilationUnitTree = Optional.empty();
        this.stack.clear();
    }

    Optional<JCTree.JCCompilationUnit> currentCompilationUnitTree() {
        return this._currentCompilationUnitTree;
    }

    boolean isInCompilationUnit() {
        return this._currentCompilationUnitTree.isPresent();
    }

    Optional<Symbol.MethodSymbol> currentOldMethodSymbol() {
        return this.curr()._currentOldMethodSymbol;
    }

    public void setCurrentOldMethodSymbol(Symbol.MethodSymbol overriddenOldMethodSymbol) {
        this.curr()._currentOldMethodSymbol = Optional.of(overriddenOldMethodSymbol);
    }

    void enterClassDecl(JCTree.JCClassDecl classDecl) {
        this.stack.add(new InternalState());
        this.curr()._currentClassDecl = Optional.of(classDecl);
        List<Symbol.MethodSymbol> classInvariants = this.javac.findInvariants(classDecl);
        this.curr()._classInvariants = this.filterInvalidInvariants(ConditionClause.createInvariants(classInvariants, this.javac, this));
        List<Type> contracts = this.retrieveContractTypes(classDecl.sym.type);
        this.logNote(classDecl.pos(), JSickoDiagnostic.ContractInterfacesNote(classDecl.sym, contracts));
        this.curr()._currentClassHasContract = !classDecl.sym.type.isInterface() && !contracts.isEmpty();
    }

    private List<ConditionClause> filterInvalidInvariants(List<ConditionClause> invariantClauses) {
        return invariantClauses.stream().filter(invariantClause -> invariantClause.getArity().map(arity -> arity.equals(0)).orElse(false)).collect(List.collector());
    }

    void exitClassDecl() {
        this.curr()._currentClassDecl = Optional.empty();
        this.curr()._optionalOldValuesTableField = Optional.empty();
        this.curr()._optionalStaticOldValuesTableField = Optional.empty();
        this.curr()._currentMethodReturnVarDecl = Optional.empty();
        this.curr()._currentMethodRaisesVarDecl = Optional.empty();
        this.curr()._overriddenOldMethod = Optional.empty();
        this.curr()._classInvariants = List.nil();
        this.curr()._currentClassHasContract = false;
        this.stack.removeLast();
    }

    Optional<JCTree.JCClassDecl> currentClassDecl() {
        return this.curr()._currentClassDecl;
    }

    public void ifClassDeclPresent(Consumer<? super JCTree.JCClassDecl> consumer) {
        this.curr()._currentClassDecl.ifPresentOrElse(consumer, () -> new IllegalStateException("No current class declaration in jSicko compiler state"));
    }

    public <U> U mapAndGetOnClassDecl(Function<? super JCTree.JCClassDecl, ? extends U> mapper) {
        return this.curr()._currentClassDecl.map(mapper).orElseThrow(() -> new IllegalStateException("No current class declaration in jSicko compiler state"));
    }

    boolean isOverriddenOldMethod(JCTree.JCMethodDecl otherMethodDecl) {
        return otherMethodDecl.equals(this.curr()._overriddenOldMethod.get());
    }

    void enterMethodDecl(JCTree.JCMethodDecl methodDecl) {
        this.curr()._currentMethodDecl = Optional.of(methodDecl);
        this.curr()._currentMethodReturnVarDecl = Optional.empty();
        this.curr()._currentMethodRaisesVarDecl = Optional.empty();
    }

    void exitMethodDecl() {
        if (this.curr()._currentClassHasContract || this.curr()._currentMethodRaisesVarDecl.isPresent()) {
            this.logNote(this.curr()._currentMethodDecl.get().pos(), JSickoDiagnostic.InstrumentedMethodNote(this.curr()._currentMethodDecl.get()));
        }
        this.curr()._currentMethodDecl = Optional.empty();
        this.curr()._currentMethodReturnVarDecl = Optional.empty();
        this.curr()._currentMethodRaisesVarDecl = Optional.empty();
    }

    List<Symbol> findOverriddenMethodsOfCurrentMethod() {
        Symbol.MethodSymbol currentMethodSymbol;
        List<Symbol> overriddenMethods = this.javac.findOverriddenMethods(this.curr()._currentClassDecl.get(), this.curr()._currentMethodDecl.get()).reverse();
        if (!overriddenMethods.contains(currentMethodSymbol = this.curr()._currentMethodDecl.get().sym)) {
            overriddenMethods.append(currentMethodSymbol);
        }
        return overriddenMethods;
    }

    boolean currentMethodShouldBeInstrumented() {
        return this.mapAndGetOnMethodDecl(methodDecl -> this.currentClassHasContract() && this.isInCompilationUnit() && !this.isOverriddenOldMethod((JCTree.JCMethodDecl)methodDecl) && methodDecl.getModifiers().getFlags().contains((Object)Modifier.PUBLIC) && !methodDecl.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT));
    }

    public <U> U mapAndGetOnMethodDecl(Function<? super JCTree.JCMethodDecl, ? extends U> mapper) {
        return this.curr()._currentMethodDecl.map(mapper).orElseThrow(() -> new IllegalStateException("No current method declaration in jSicko compiler state"));
    }

    public void ifMethodDeclPresent(Consumer<? super JCTree.JCMethodDecl> consumer) {
        this.curr()._currentMethodDecl.ifPresentOrElse(consumer, () -> new IllegalStateException("No current method declaration in jSicko compiler state"));
    }

    public Optional<JCTree.JCVariableDecl> currentMethodReturnVarDecl() {
        return this.curr()._currentMethodReturnVarDecl;
    }

    Optional<JCTree.JCVariableDecl> optionalOldValuesTableField() {
        return this.curr()._optionalOldValuesTableField;
    }

    JCTree.JCVariableDecl oldValuesTableFieldDeclByMethodType() {
        return this.curr()._currentMethodDecl.get().sym.isStatic() ? this.curr()._optionalStaticOldValuesTableField.get() : this.curr()._optionalOldValuesTableField.get();
    }

    void overrideOldMethod(JCTree.JCMethodDecl overriddenOldMethod) {
        JCTree.JCClassDecl classDecl = this.curr()._currentClassDecl.get();
        JCDiagnostic.DiagnosticPosition prevPos = ((JCTree)classDecl.defs.head).pos();
        classDecl.defs = classDecl.defs.prepend(overriddenOldMethod);
        classDecl.sym.members().enter(overriddenOldMethod.sym);
        this.curr()._overriddenOldMethod = Optional.of(overriddenOldMethod);
        this.logNote(prevPos, JSickoDiagnostic.OverriddenOldMethodNote(overriddenOldMethod));
    }

    void appendOldValuesTableField(JCTree.JCVariableDecl varDef, boolean isTheStaticOne) {
        if (isTheStaticOne) {
            this.curr()._optionalStaticOldValuesTableField = Optional.of(varDef);
        } else {
            this.curr()._optionalOldValuesTableField = Optional.of(varDef);
        }
        this.curr()._currentClassDecl.get().defs = this.curr()._currentClassDecl.get().defs.prepend(varDef);
        this.curr()._currentClassDecl.get().sym.members().enter(varDef.sym);
    }

    Optional<JCTree.JCVariableDecl> currentMethodRaisesVarDecl() {
        return this.curr()._currentMethodRaisesVarDecl;
    }

    void setCurrentMethodReturnVarDecl(JCTree.JCVariableDecl varDef) {
        this.curr()._currentMethodReturnVarDecl = Optional.of(varDef);
    }

    void setCurrentMethodRaisesVarDecl(JCTree.JCVariableDecl varDef) {
        this.curr()._currentMethodRaisesVarDecl = Optional.of(varDef);
    }

    List<ConditionClause> classInvariants() {
        return this.curr()._classInvariants;
    }

    void logNote(JCDiagnostic.DiagnosticPosition pos, JSickoDiagnostic.JSickoNote note) {
        this.javac.logNote(this._currentCompilationUnitTree.get().getSourceFile(), pos, note);
    }

    void logError(JCDiagnostic.DiagnosticPosition pos, JSickoDiagnostic.JSickoError error) {
        this.javac.logError(this._currentCompilationUnitTree.get().getSourceFile(), pos, error);
    }

    public boolean isCurrentMethodDecl(Tree tree) {
        return tree.equals(this.curr()._currentMethodDecl.get());
    }

    private List<Type> retrieveContractTypes(Type t) {
        Name contractTypeName = this.javac.Name(Contract.class.getCanonicalName());
        List<Type> closure = this.javac.typeClosure(t);
        Optional<Type> contractType = closure.stream().filter(closureElem -> {
            Type rawType = this.javac.typeErasure((Type)closureElem);
            return rawType.asElement().getQualifiedName().equals(contractTypeName);
        }).map(likelyContractType -> this.javac.typeErasure((Type)likelyContractType)).findFirst();
        if (contractType.isPresent()) {
            return closure.stream().filter(closureElem -> {
                Type rawType = this.javac.typeErasure((Type)closureElem);
                return rawType.isInterface() && this.javac.isTypeAssignable(rawType, (Type)contractType.get());
            }).collect(List.collector());
        }
        return List.nil();
    }

    private class InternalState {
        boolean _currentClassHasContract = false;
        Optional<JCTree.JCClassDecl> _currentClassDecl = Optional.empty();
        Optional<JCTree.JCMethodDecl> _currentMethodDecl = Optional.empty();
        List<ConditionClause> _classInvariants = List.nil();
        Optional<JCTree.JCVariableDecl> _currentMethodReturnVarDecl = Optional.empty();
        Optional<JCTree.JCVariableDecl> _currentMethodRaisesVarDecl = Optional.empty();
        Optional<JCTree.JCVariableDecl> _optionalOldValuesTableField = Optional.empty();
        Optional<JCTree.JCVariableDecl> _optionalStaticOldValuesTableField = Optional.empty();
        Optional<JCTree.JCMethodDecl> _overriddenOldMethod = Optional.empty();
        Optional<Symbol.MethodSymbol> _currentOldMethodSymbol = Optional.empty();

        private InternalState() {
        }
    }
}

