/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.codelounge.jsicko;

import ch.usi.si.codelounge.jsicko.plugin.OldValuesTable;
import ch.usi.si.codelounge.jsicko.plugin.diagnostics.JSickoError;
import ch.usi.si.codelounge.jsicko.plugin.utils.ConditionChecker;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

public interface Contract {
    default public OldValuesTable emptyOldValuesTable() {
        return new OldValuesTable();
    }

    default public ConditionChecker emptyPreconditionChecker() {
        return ConditionChecker.newPreconditionChecker();
    }

    default public <X> X instanceOld(String rep, X object) {
        throw new JSickoError("Illegal call of instanceOld(rep,object) method outside a compiled contract");
    }

    public static <X> X staticOld(Class<? extends Contract> clazz, String rep, X object) {
        try {
            Field staticOldValuesTableField = clazz.getDeclaredField("$staticOldValuesTable");
            OldValuesTable staticOldValuesTable = (OldValuesTable)staticOldValuesTableField.get(null);
            if (!staticOldValuesTable.containsKey(rep)) {
                throw new JSickoError("[jsicko] values table does not contain key " + rep + "; check for clauses using old(.) in a pure method contract");
            }
            return (X)staticOldValuesTable.getValue(rep);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new JSickoError("Illegal call of staticOld(" + clazz + ",rep,object) method outside a compiled contract", e);
        }
    }

    public static <T> T old(T object) {
        throw new JSickoError("Illegal call of old(object) method outside a compiled contract");
    }

    default public boolean pure() {
        return this.equals(Contract.old(this));
    }

    public static final class InvariantViolation
    extends ContractConditionViolation {
        public InvariantViolation(Object detailMessage) {
            super((Object)String.valueOf(detailMessage));
        }
    }

    public static final class PostconditionViolation
    extends ContractConditionViolation {
        public PostconditionViolation(Object detailMessage) {
            super((Object)String.valueOf(detailMessage));
        }
    }

    public static final class PreconditionViolation
    extends ContractConditionViolation {
        public PreconditionViolation(Object detailMessage) {
            super((Object)String.valueOf(detailMessage));
        }
    }

    public static abstract class ContractConditionViolation
    extends AssertionError {
        public ContractConditionViolation(Object detailMessage) {
            super((Object)String.valueOf(detailMessage));
        }
    }

    @Target(value={ElementType.METHOD})
    public static @interface Pure {
    }

    @Target(value={ElementType.METHOD})
    public static @interface Invariant {
    }

    @Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR})
    public static @interface Ensures {
        public String[] value();
    }

    @Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR})
    public static @interface Requires {
        public String[] value();
    }
}

