/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.codelounge.jsicko.plugin.utils;

import ch.usi.si.codelounge.jsicko.Contract;
import ch.usi.si.codelounge.jsicko.plugin.OldValuesTable;
import ch.usi.si.codelounge.jsicko.plugin.diagnostics.JSickoDiagnostic;
import ch.usi.si.codelounge.jsicko.plugin.utils.ConditionChecker;
import com.google.common.collect.Streams;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeMetadata;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;

public final class JavacUtils {
    private static final String JAVA_CONSTRUCTOR_REP = "<init>";
    private final Types types;
    private final Symtab symtab;
    private final Names symbolsTable;
    private final TreeMaker factory;
    private final TransTypes transTypes;
    private final Attr attr;
    private final Log log;
    private final JCDiagnostic.Factory diagnosticFactory;
    private final Type _throwableType;
    private final Type _exceptionType;
    private final Type _runtimeExceptionType;
    private final Type _objectType;
    private final Symbol javaUtilCollectionIteratorMethodSymbol;
    private final Symbol.ModuleSymbol _unnamedModule;
    private final Symbol.ModuleSymbol _javaBaseModule;

    public JavacUtils(BasicJavacTask task) {
        this.symbolsTable = Names.instance(task.getContext());
        this.types = Types.instance(task.getContext());
        this.factory = TreeMaker.instance(task.getContext());
        this.symtab = Symtab.instance(task.getContext());
        this.log = Log.instance(task.getContext());
        this.diagnosticFactory = JCDiagnostic.Factory.instance(task.getContext());
        this.transTypes = TransTypes.instance(task.getContext());
        this.attr = Attr.instance(task.getContext());
        Optional<Symbol> javaUtilCollectioniteratorMethodSymbol = this.retrieveMemberFromClassByName(this.symtab.java_base, Collection.class.getCanonicalName(), "iterator");
        this._unnamedModule = this.symtab.unnamedModule;
        this._javaBaseModule = this.symtab.java_base;
        if (!javaUtilCollectioniteratorMethodSymbol.isPresent()) {
            throw new IllegalStateException("JSicko Fatal Error: missing java.util.Collection symbol.");
        }
        this.javaUtilCollectionIteratorMethodSymbol = javaUtilCollectioniteratorMethodSymbol.get();
        this._throwableType = this.retrieveClassSymbol((Symbol.ModuleSymbol)this.symtab.java_base, (String)Throwable.class.getCanonicalName()).get().type;
        this._exceptionType = this.retrieveClassSymbol((Symbol.ModuleSymbol)this.symtab.java_base, (String)Exception.class.getCanonicalName()).get().type;
        this._runtimeExceptionType = this.retrieveClassSymbol((Symbol.ModuleSymbol)this.symtab.java_base, (String)RuntimeException.class.getCanonicalName()).get().type;
        this._objectType = this.retrieveClassSymbol((Symbol.ModuleSymbol)this.symtab.java_base, (String)Object.class.getCanonicalName()).get().type;
    }

    public TreeMaker getFactory() {
        return this.factory;
    }

    public JCTree.JCExpression Expression(Symbol.ModuleSymbol moduleSymbol, String classQualifiedName) {
        Type classType = this.typeErasure(this.retrieveType(moduleSymbol, classQualifiedName));
        return this.factory.Type(classType);
    }

    public JCTree.JCExpression Expression(Symbol.ModuleSymbol moduleSymbol, String classQualifiedName, String methodName) {
        Type classType = this.retrieveType(moduleSymbol, classQualifiedName);
        Symbol method = this.retrieveMemberFromClassByName(moduleSymbol, classQualifiedName, methodName).get();
        return this.factory.Select(this.factory.Type(classType), method);
    }

    public JCTree.JCExpression Erroneous() {
        return this.factory.Erroneous();
    }

    public List<Type> typeClosure(Type t) {
        return this.types.closure(t);
    }

    public Type typeErasure(Type t) {
        return t.asElement().erasure(this.types);
    }

    public Name Name(String name) {
        return this.symbolsTable.fromString(name);
    }

    public Symbol.ModuleSymbol unnamedModule() {
        return this._unnamedModule;
    }

    public Symbol.ModuleSymbol javaBaseModule() {
        return this._javaBaseModule;
    }

    public JCTree.JCStatement MethodCall(Symbol.ModuleSymbol moduleSymbol, JCTree.JCExpression baseExpression, Name methodName, List<JCTree.JCExpression> args) {
        return this.factory.Exec(this.MethodInvocation(moduleSymbol, baseExpression, methodName, args));
    }

    public JCTree.JCStatement MethodCall(Symbol.ModuleSymbol moduleSymbol, JCTree.JCExpression baseExpression, Name methodName) {
        return this.MethodCall(moduleSymbol, baseExpression, methodName, List.nil());
    }

    public JCTree.JCMethodInvocation MethodInvocation(Symbol.ModuleSymbol moduleSymbol, JCTree.JCExpression baseExpression, Name methodName, List<JCTree.JCExpression> args) {
        Symbol.MethodSymbol sym = (Symbol.MethodSymbol)this.retrieveMemberFromClassByName(moduleSymbol, baseExpression.type.tsym.getQualifiedName().toString(), methodName.toString(), args.map(a -> a.type)).get();
        JCTree.JCExpression selector = this.factory.Select(baseExpression, sym);
        JCTree.JCMethodInvocation apply = this.factory.Apply(List.nil(), selector, args);
        if (sym.isVarArgs()) {
            Type paramType = ((Symbol.VarSymbol)sym.params.head).type;
            apply.varargsElement = ((Type.ArrayType)paramType).getComponentType();
        }
        return apply.setType(selector.type.getReturnType());
    }

    public JCTree.JCMethodInvocation MethodInvocation(Symbol.ModuleSymbol moduleSymbol, JCTree.JCExpression baseExpression, Name methodName) {
        return this.MethodInvocation(moduleSymbol, baseExpression, methodName, List.nil());
    }

    public boolean isTypeAssignable(Type t, Type s2) {
        return this.types.isAssignable(t, s2);
    }

    public boolean isTypeAssignable(Symbol.VarSymbol a, Symbol.VarSymbol b) {
        Type aType = a.type.isPrimitive() ? a.type : a.erasure(this.types);
        Type bType = b.type.isPrimitive() ? b.type : b.erasure(this.types);
        return this.types.isAssignable(aType, bType);
    }

    public List<Symbol> findOverriddenMethods(JCTree.JCClassDecl classDecl, JCTree.JCMethodDecl methodDecl) {
        Symbol.MethodSymbol methodSymbol = methodDecl.sym;
        List<Type> thisTypeClosure = this.typeClosure(classDecl.sym.type);
        return thisTypeClosure.stream().flatMap(contractType -> contractType.tsym.getEnclosedElements().stream().filter(contractElement -> methodSymbol.getQualifiedName().equals(contractElement.name) && methodSymbol.overrides((Symbol)contractElement, contractType.tsym, this.types, true, true))).collect(List.collector());
    }

    public boolean hasVoidReturnType(JCTree.JCMethodDecl methodDecl) {
        JCTree methodReturnType = methodDecl.getReturnType();
        return methodReturnType instanceof JCTree.JCPrimitiveTypeTree && ((JCTree.JCPrimitiveTypeTree)methodReturnType).typetag.equals((Object)TypeTag.VOID);
    }

    public JCTree.JCLiteral zeroValue(Type t) {
        if (t.equals(this.symtab.intType) || t.equals(this.symtab.charType) || t.equals(this.symtab.byteType) || t.equals(this.symtab.longType)) {
            return this.factory.Literal(t.getTag(), 0);
        }
        if (t.equals(this.symtab.booleanType)) {
            return this.factory.Literal(t.getTag(), 0);
        }
        if (t.equals(this.symtab.doubleType)) {
            return this.factory.Literal(t.getTag(), 0.0);
        }
        if (t.equals(this.symtab.floatType)) {
            return this.factory.Literal(t.getTag(), Float.valueOf(0.0f));
        }
        return this.nullLiteral();
    }

    public JCTree.JCLiteral nullLiteral() {
        return this.factory.Literal(TypeTag.BOT, null);
    }

    public List<Symbol.MethodSymbol> findInvariants(JCTree.JCClassDecl classDecl) {
        List<Type> thisTypeClosure = this.typeClosure(classDecl.sym.type);
        return thisTypeClosure.stream().flatMap(contractType -> {
            Stream<Symbol> contractOverriddenSymbols = contractType.tsym.getEnclosedElements().stream().filter(contractElement -> contractElement instanceof Symbol.MethodSymbol && contractElement.getAnnotation(Contract.Invariant.class) != null);
            return contractOverriddenSymbols.map(Symbol.MethodSymbol.class::cast);
        }).collect(List.collector());
    }

    public boolean isSuperOrThisConstructorCall(JCTree.JCStatement head) {
        return head instanceof JCTree.JCExpressionStatement && ((JCTree.JCExpressionStatement)head).expr instanceof JCTree.JCMethodInvocation && ((JCTree.JCMethodInvocation)((JCTree.JCExpressionStatement)head).expr).meth instanceof JCTree.JCIdent && (((JCTree.JCIdent)((JCTree.JCMethodInvocation)((JCTree.JCExpressionStatement)head).expr).meth).name.equals(this.symbolsTable._super) || ((JCTree.JCIdent)((JCTree.JCMethodInvocation)((JCTree.JCExpressionStatement)head).expr).meth).name.equals(this.symbolsTable._this));
    }

    public Type oldValuesTableClassType() {
        Symbol.ClassSymbol mapClassSymbol = this.symtab.getClassesForName(this.Name(OldValuesTable.class.getCanonicalName())).iterator().next();
        return new Type.ClassType((Type)Type.noType, List.nil(), (Symbol.TypeSymbol)mapClassSymbol, TypeMetadata.EMPTY);
    }

    public Type preconditionCheckerType() {
        Symbol.ClassSymbol mapClassSymbol = this.symtab.getClassesForName(this.Name(ConditionChecker.class.getCanonicalName())).iterator().next();
        return new Type.ClassType((Type)Type.noType, List.nil(), (Symbol.TypeSymbol)mapClassSymbol, TypeMetadata.EMPTY);
    }

    public Type.TypeVar freshObjectTypeVar(Symbol owner) {
        Symbol.TypeVariableSymbol typeSymbol = new Symbol.TypeVariableSymbol(0L, this.symbolsTable.fromString("X"), null, owner);
        Type.TypeVar typeVar = new Type.TypeVar(typeSymbol, this.symtab.objectType, this.symtab.botType);
        typeSymbol.type = typeVar;
        return typeVar;
    }

    public JCTree.JCExpression oldValuesTableTypeExpression() {
        Type mapTypeIdent = this.retrieveType(this.symtab.noModule, OldValuesTable.class.getCanonicalName());
        return this.factory.Type(mapTypeIdent);
    }

    public Type oldValuesTableType() {
        return this.retrieveType(this.symtab.noModule, OldValuesTable.class.getCanonicalName());
    }

    public JCTree.JCExpression Type(Type tpe) {
        return this.factory.Type(tpe);
    }

    public Type stringType() {
        return this.symtab.stringType;
    }

    public Type throwableType() {
        return this._throwableType;
    }

    public Type exceptionType() {
        return this._exceptionType;
    }

    public Type objectType() {
        return this._objectType;
    }

    public Type runtimeExceptionType() {
        return this._runtimeExceptionType;
    }

    public void logError(JavaFileObject fileObject, JCDiagnostic.DiagnosticPosition pos, JSickoDiagnostic.JSickoError jsickoError) {
        JCDiagnostic diagnosticError = this.diagnosticFactory.error(JCDiagnostic.DiagnosticFlag.MANDATORY, new DiagnosticSource(fileObject, this.log), pos, jsickoError.jcError());
        this.log.report(diagnosticError);
    }

    public void logWarning(JCDiagnostic.DiagnosticPosition pos, JSickoDiagnostic.JSickoWarning warning) {
        this.log.mandatoryWarning(pos, warning.jcWarning());
    }

    public void logNote(JavaFileObject fileObject, JCDiagnostic.DiagnosticPosition pos, JSickoDiagnostic.JSickoNote note) {
        JCDiagnostic sourcedDiagnosticNote = this.diagnosticFactory.create(null, EnumSet.of(JCDiagnostic.DiagnosticFlag.MANDATORY), new DiagnosticSource(fileObject, this.log), pos, note.jcNote());
        this.log.report(sourcedDiagnosticNote);
    }

    public Optional<Symbol> retrieveMemberFromClassByName(Symbol.ModuleSymbol moduleSymbol, String qualifiedClassName, String methodName) {
        Optional<Symbol.ClassSymbol> mapClassSymbol = this.retrieveClassSymbol(moduleSymbol, qualifiedClassName);
        Optional<Symbol> local = mapClassSymbol.map(s2 -> s2.members().findFirst(this.symbolsTable.fromString(methodName)));
        if (!local.isPresent() && mapClassSymbol.isPresent() && mapClassSymbol.get().isInner()) {
            Symbol inner = mapClassSymbol.get().owner.members().findFirst(this.symbolsTable.fromString(methodName));
            return Optional.of(inner);
        }
        return local;
    }

    private Optional<Symbol> retrieveMemberFromClassByName(Symbol.ModuleSymbol moduleSymbol, String qualifiedClassName, String methodName, List<Type> types) {
        Optional<Symbol.ClassSymbol> mapClassSymbol = this.retrieveClassSymbol(moduleSymbol, qualifiedClassName);
        Optional<Symbol> local = mapClassSymbol.map(s2 -> s2.members().findFirst(this.symbolsTable.fromString(methodName), t -> {
            if (!(t instanceof Symbol.MethodSymbol)) {
                return false;
            }
            Symbol.MethodSymbol ms = (Symbol.MethodSymbol)t;
            if (ms.isVarArgs()) {
                return true;
            }
            if (ms.params.length() != types.length()) {
                return false;
            }
            Stream msts = ms.params.map(x -> x.type).stream();
            Stream pts = types.stream();
            Stream<Boolean> matches = Streams.zip(msts, pts, (t1, t2) -> this.types.isAssignable((Type)t2, (Type)t1));
            return matches.allMatch(b -> b);
        })).or(() -> mapClassSymbol.map(s2 -> s2.members().findFirst(this.symbolsTable.fromString(methodName))));
        if (!local.isPresent() && mapClassSymbol.isPresent() && mapClassSymbol.get().isInner()) {
            Symbol inner = mapClassSymbol.get().owner.members().findFirst(this.symbolsTable.fromString(methodName));
            return Optional.of(inner);
        }
        return local;
    }

    private Optional<Symbol.ClassSymbol> retrieveClassSymbol(Symbol.ModuleSymbol moduleSymbol, String qualifiedClassName) {
        Iterator<Symbol.ClassSymbol> symbols = this.symtab.getClassesForName(this.Name(qualifiedClassName)).iterator();
        if (symbols.hasNext()) {
            Symbol.ClassSymbol symbol = symbols.next();
            return Optional.of(symbol);
        }
        Symbol.ClassSymbol inBase = this.symtab.enterClass(moduleSymbol, this.symbolsTable.fromString(qualifiedClassName));
        return Optional.of(inBase);
    }

    public Symbol getJavaUtilCollectionIteratorMethodSymbol() {
        return this.javaUtilCollectionIteratorMethodSymbol;
    }

    public Type deriveMostGeneralExceptionTypeThrown(List<JCTree.JCExpression> throwsList) {
        for (JCTree.JCExpression throwClause : throwsList) {
            if (!this.types.isAssignable(throwClause.type, this._runtimeExceptionType) && !this.types.isAssignable(throwClause.type, this._exceptionType)) {
                return this._throwableType;
            }
            if (this.types.isAssignable(throwClause.type, this._runtimeExceptionType)) continue;
            return this._exceptionType;
        }
        return this._runtimeExceptionType;
    }

    public Type retrieveType(Symbol.ModuleSymbol moduleSymbol, String canonicalName) {
        return this.retrieveClassSymbol((Symbol.ModuleSymbol)moduleSymbol, (String)canonicalName).get().type;
    }

    public Symbol retrieveConstructor(Symbol.ModuleSymbol moduleSymbol, String canonicalName) {
        return this.retrieveClassSymbol(moduleSymbol, canonicalName).get().members().findFirst(this.symbolsTable.fromString(JAVA_CONSTRUCTOR_REP));
    }

    public Symbol retrieveConstructor(Symbol.ModuleSymbol moduleSymbol, String canonicalName, Type ... argTypes) {
        return this.retrieveClassSymbol(moduleSymbol, canonicalName).get().members().findFirst(this.symbolsTable.fromString(JAVA_CONSTRUCTOR_REP), f -> {
            if (!(f instanceof Symbol.MethodSymbol)) {
                return false;
            }
            List<Symbol.VarSymbol> symbolParams = ((Symbol.MethodSymbol)f).params();
            if (argTypes.length != symbolParams.length()) {
                return false;
            }
            for (int i = 0; i < symbolParams.length(); ++i) {
                Symbol.VarSymbol symbolParam = symbolParams.get(i);
                Type paramToCheck = argTypes[i];
                if (symbolParam.type.asElement().equals(paramToCheck.asElement())) continue;
                return false;
            }
            return true;
        });
    }

    public Symbol retrieveEmptyConstructor(Symbol.ModuleSymbol moduleSymbol, String canonicalName) {
        return this.retrieveClassSymbol(moduleSymbol, canonicalName).get().members().findFirst(this.symbolsTable.fromString(JAVA_CONSTRUCTOR_REP), f -> f instanceof Symbol.MethodSymbol && ((Symbol.MethodSymbol)f).params().length() == 0);
    }

    public void setOperator(JCTree.JCUnary unaryOp) {
        unaryOp.operator = new Symbol.OperatorSymbol(this.Name("!"), this.symtab.booleanType, 257, (Symbol)this.symtab.noSymbol);
        unaryOp.type = this.booleanType();
    }

    public void setStringOperator(JCTree.JCBinary binary) {
        Type.MethodType opType = new Type.MethodType(List.of(this.stringType(), this.stringType()), this.stringType(), List.nil(), this.symtab.methodClass);
        binary.operator = new Symbol.OperatorSymbol(this.Name("+"), opType, 256, (Symbol)this.symtab.noSymbol);
        binary.type = this.stringType();
    }

    public void setEqOperator(JCTree.JCBinary binary) {
        Type.MethodType opType = new Type.MethodType(List.of(this.objectType(), this.objectType()), this.booleanType(), List.nil(), this.symtab.methodClass);
        binary.operator = new Symbol.OperatorSymbol(this.Name("=="), opType, 165, (Symbol)this.symtab.noSymbol);
        binary.type = this.booleanType();
    }

    public Type booleanType() {
        return this.symtab.booleanType;
    }

    public Type voidType() {
        return this.symtab.voidType;
    }

    public Type botType() {
        return this.symtab.botType;
    }

    public void visitLambda(JCTree.JCLambda lambda) {
        Symbol.VarSymbol t = (Symbol.VarSymbol)this.retrieveMemberFromClassByName(this.unnamedModule(), "ch.usi.si.codelounge.jsicko.plugin.utils.ConditionChecker", "dummy").get();
        lambda.type = t.type;
        lambda.target = t.type;
    }

    public Type zeroType(Type t) {
        return t.isPrimitive() ? t : this.botType();
    }

    public JCTree.JCExpression falseLiteral() {
        return this.zeroValue(this.booleanType());
    }

    @NotNull
    public JCTree.JCBinary buildNullCheckCondition(JCTree.JCVariableDecl oldValuesTableFieldDecl) {
        JCTree.JCIdent oldValuesTableIdent0 = this.factory.Ident(oldValuesTableFieldDecl.sym);
        oldValuesTableIdent0.setType(oldValuesTableFieldDecl.type);
        JCTree.JCLiteral nullValue = this.nullLiteral();
        nullValue.type = this.botType();
        JCTree.JCBinary checkCondition = this.factory.Binary(JCTree.Tag.EQ, oldValuesTableIdent0, nullValue);
        this.setEqOperator(checkCondition);
        return checkCondition;
    }
}

