/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.codelounge.jsicko;

import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public abstract class ContractUtils {
    public static final BinaryOperator<Boolean> implies = (antecedent, consequent) -> antecedent == false || consequent != false;
    public static final BinaryOperator<Boolean> iff = Objects::equals;

    private ContractUtils() {
    }

    @Deprecated(forRemoval=true)
    public static boolean implies(boolean antecedent, boolean consequent) {
        return !antecedent || consequent;
    }

    public static boolean implies(boolean antecedent, BooleanSupplier consequent) {
        return !antecedent || consequent.getAsBoolean();
    }

    public static boolean implies(boolean antecedent, BooleanSupplier consequent, BooleanSupplier elseCondition) {
        return !(antecedent && !consequent.getAsBoolean() || !antecedent && !elseCondition.getAsBoolean());
    }

    public static boolean iff(boolean a, boolean b) {
        return a == b;
    }

    public static boolean forAllInts(int lower, int upper, IntPredicate argument) {
        return IntStream.range(lower, upper).allMatch(argument);
    }

    public static <E> boolean forAll(Collection<E> collection, Predicate<E> argument) {
        return collection.stream().allMatch(argument);
    }

    public static boolean existsInt(int lower, int upper, IntPredicate argument) {
        return IntStream.range(lower, upper).anyMatch(argument);
    }

    public static <E> boolean exists(Collection<E> collection, Predicate<E> argument) {
        return collection.stream().anyMatch(argument);
    }

    public static <E> long count(Collection<E> collection, Predicate<E> argument) {
        return collection.stream().filter(argument).count();
    }

    public static <T extends Comparable<? super T>> boolean isSorted(Collection<T> returns) {
        return Ordering.natural().isOrdered(returns);
    }
}

