/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.codelounge.jsicko.plugin;

import ch.usi.si.codelounge.jsicko.Contract;
import ch.usi.si.codelounge.jsicko.plugin.ContractConditionEnum;
import ch.usi.si.codelounge.jsicko.plugin.JSickoContractCompilerState;
import ch.usi.si.codelounge.jsicko.plugin.diagnostics.JSickoDiagnostic;
import ch.usi.si.codelounge.jsicko.plugin.utils.JavacUtils;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.jetbrains.annotations.NotNull;

public class ConditionClause {
    private static final String CLAUSE_REP = "clause";
    private static final Pattern clauseFormatRegexp = Pattern.compile("(\\!?)([A-Za-z]\\w*)");
    private final JavacUtils javac;
    private final JSickoContractCompilerState state;
    private final TreeMaker factory;
    private final boolean isNegated;
    private final Name methodName;
    private final ContractConditionEnum conditionType;
    private final String clauseRep;
    private Optional<Symbol.MethodSymbol> resolvedMethodSymbol;
    private final Symbol declaringSymbol;

    private ConditionClause(JSickoContractCompilerState state, JavacUtils javac, Symbol declaringSymbol, String clauseRep, ContractConditionEnum conditionType) {
        Matcher clauseRepFormatMatcher = clauseFormatRegexp.matcher(clauseRep);
        if (!clauseRepFormatMatcher.matches()) {
            throw new IllegalArgumentException("Clause specification name \"" + clauseRep + "\" is malformed. Please use a valid Java identifier / match regexp " + clauseFormatRegexp);
        }
        this.state = state;
        this.javac = javac;
        this.factory = javac.getFactory();
        this.isNegated = !clauseRepFormatMatcher.group(1).isEmpty();
        this.methodName = javac.Name(clauseRepFormatMatcher.group(2));
        this.clauseRep = "clause " + clauseRep + " in " + declaringSymbol.owner.getSimpleName() + "#" + declaringSymbol;
        this.declaringSymbol = declaringSymbol;
        this.conditionType = conditionType;
    }

    private ConditionClause(JSickoContractCompilerState state, JavacUtils javac, Symbol.MethodSymbol invariantSymbol) {
        this.state = state;
        this.javac = javac;
        this.factory = javac.getFactory();
        this.isNegated = false;
        this.methodName = invariantSymbol.name;
        this.clauseRep = "clause " + invariantSymbol + " in " + invariantSymbol.owner.getSimpleName();
        this.conditionType = ContractConditionEnum.INVARIANT;
        this.declaringSymbol = invariantSymbol.owner;
        this.resolvedMethodSymbol = Optional.of(invariantSymbol);
    }

    public String getClauseRep() {
        return this.clauseRep;
    }

    public Optional<Integer> getArity() {
        return this.resolvedMethodSymbol.map(methodSymbol -> methodSymbol.params().length());
    }

    public String getResolvedClauseRepWithNames() {
        if (this.conditionType.equals((Object)ContractConditionEnum.INVARIANT)) {
            return this.clauseRep;
        }
        String clauseRepWithNames = this.resolvedMethodSymbol.map(s -> (Name)s.getSimpleName() + "(" + s.params().map(p -> p.type + " " + p.name).toString(", ") + ")").orElse(this.methodName.toString());
        String declaringSymbolWithNames = this.declaringSymbol.getSimpleName() + "(" + ((Symbol.MethodSymbol)this.declaringSymbol).params().map(p -> p.type + " " + p.name).toString(", ") + ")";
        return "clause " + clauseRepWithNames + " in " + this.declaringSymbol.owner.getSimpleName() + "#" + declaringSymbolWithNames;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public Name getMethodName() {
        return this.methodName;
    }

    public ContractConditionEnum getConditionType() {
        return this.conditionType;
    }

    public boolean isResolved() {
        return this.resolvedMethodSymbol.isPresent();
    }

    public static List<ConditionClause> from(Contract.Ensures postconditionAnnotation, Symbol declaringSymbol, JavacUtils javac, JSickoContractCompilerState state) {
        return Arrays.stream(postconditionAnnotation.value()).map(clauseRep -> new ConditionClause(state, javac, declaringSymbol, (String)clauseRep, ContractConditionEnum.POSTCONDITION)).collect(List.collector());
    }

    public static List<ConditionClause> from(Contract.Requires preconditionAnnotation, Symbol declaringSymbol, JavacUtils javac, JSickoContractCompilerState state) {
        return Arrays.stream(preconditionAnnotation.value()).map(clauseRep -> new ConditionClause(state, javac, declaringSymbol, (String)clauseRep, ContractConditionEnum.PRECONDITION)).collect(List.collector());
    }

    public static List<ConditionClause> createInvariants(List<Symbol.MethodSymbol> invariants, JavacUtils javac, JSickoContractCompilerState state) {
        return invariants.stream().map(invariantSymbol -> new ConditionClause(state, javac, (Symbol.MethodSymbol)invariantSymbol)).collect(List.collector());
    }

    JCTree.JCLambda createConditionLambda(JCTree.JCVariableDecl checkerVarDef, JCTree.JCMethodDecl methodDecl) {
        Type stringBuilderType = this.javac.retrieveType(this.javac.javaBaseModule(), "java.lang.StringBuilder");
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(0L, this.javac.Name("$msg"), stringBuilderType, methodDecl.sym);
        JCTree.JCNewClass init = this.factory.NewClass(null, List.nil(), this.javac.Type(stringBuilderType), List.nil(), null);
        init.constructor = this.javac.retrieveEmptyConstructor(this.javac.unnamedModule(), "java.lang.StringBuilder");
        init.setType(stringBuilderType);
        JCTree.JCVariableDecl varDef = this.factory.VarDef(varSymbol, init);
        JCTree.JCIdent stringBuilderIdent = this.factory.Ident(varSymbol);
        stringBuilderIdent.type = stringBuilderType;
        stringBuilderIdent.sym = varSymbol;
        List<JCTree.JCStatement> stmts = this.createParamValuesStringExpression(checkerVarDef, stringBuilderIdent, methodDecl, List.of(this.factory.Literal(this.clauseRep + "; params: ")));
        JCTree.JCMethodInvocation binaryPlus = this.javac.MethodInvocation(this.javac.javaBaseModule(), stringBuilderIdent, this.javac.Name("toString"), List.nil());
        JCTree.JCReturn optionalOfCall = this.factory.Return(this.javac.MethodInvocation(this.javac.unnamedModule(), this.javac.Expression(this.javac.unnamedModule(), "java.util.Optional"), this.javac.Name("of"), List.of(binaryPlus)));
        List<JCTree.JCStatement> allStmts = stmts.prepend(varDef).append(optionalOfCall);
        JCTree.JCBlock ifThen = this.factory.Block(0L, allStmts);
        JCTree.JCMethodInvocation optionalEmptyCall = this.javac.MethodInvocation(this.javac.unnamedModule(), this.javac.Expression(this.javac.unnamedModule(), "java.util.Optional"), this.javac.Name("empty"));
        JCTree.JCIf lambdaBody = this.factory.If(this.createConditionCheckExpression(methodDecl), ifThen, this.factory.Return(optionalEmptyCall));
        JCTree.JCLambda lambda = this.factory.Lambda(List.nil(), this.factory.Block(0L, List.of(lambdaBody)));
        this.javac.visitLambda(lambda);
        return lambda;
    }

    private JCTree.JCExpression createConditionCheckExpression(JCTree.JCMethodDecl methodDecl) {
        Symbol.MethodSymbol clauseSymbol = this.resolvedMethodSymbol.get();
        List<Optional<Symbol.VarSymbol>> resolvedVarSymbols = this.resolveVarSymbols(methodDecl, clauseSymbol, true);
        if (resolvedVarSymbols.stream().anyMatch(Optional::isEmpty)) {
            return this.javac.falseLiteral();
        }
        List<JCTree.JCExpression> args = ConditionClause.buildExpressionsFromSymbols(this.factory, resolvedVarSymbols);
        JCTree.JCIdent ident = this.factory.Ident(this.resolvedMethodSymbol.get());
        ident.setType(this.resolvedMethodSymbol.get().type);
        ident.sym = this.resolvedMethodSymbol.get();
        JCTree.JCMethodInvocation call = this.factory.App(ident, List.from(args.toArray(new JCTree.JCExpression[0])));
        JCTree.JCUnary unaryOp = this.factory.Unary(JCTree.Tag.NOT, call);
        this.javac.setOperator(unaryOp);
        JCTree.JCExpression potentiallyNegatedCall = this.isNegated() ? call : unaryOp;
        JCTree.JCParens result = this.factory.Parens(potentiallyNegatedCall);
        result.setType(this.javac.booleanType());
        return result;
    }

    private static List<JCTree.JCExpression> buildExpressionsFromSymbols(TreeMaker factory, List<Optional<Symbol.VarSymbol>> resolvedVarSymbols) {
        return resolvedVarSymbols.stream().map(o -> (Symbol.VarSymbol)o.get()).map(symbol -> {
            JCTree.JCIdent ident = factory.Ident((Symbol)symbol);
            ident.setType(symbol.type);
            ident.sym = symbol;
            return ident;
        }).collect(List.collector());
    }

    private List<Optional<Symbol.VarSymbol>> resolveVarSymbols(JCTree.JCMethodDecl methodDecl, Symbol.MethodSymbol clauseSymbol, boolean checkUsage) {
        return clauseSymbol.params().stream().map(clauseParamSymbol -> {
            String clauseParamName = clauseParamSymbol.name.toString();
            Optional<Symbol.VarSymbol> symbol = clauseParamName.equals("returns") ? this.retrieveReturnsVarSymbol(methodDecl, checkUsage) : (clauseParamName.equals("raises") ? this.retrieveRaisesVarSymbol(methodDecl, checkUsage) : this.retrieveParamSymbol(methodDecl, (Symbol.VarSymbol)clauseParamSymbol));
            if (symbol.isPresent() && !this.javac.isTypeAssignable(symbol.get(), (Symbol.VarSymbol)clauseParamSymbol)) {
                this.state.logError(methodDecl.pos(), JSickoDiagnostic.WrongParamType(clauseParamSymbol.name, symbol.get().type, clauseParamSymbol.type, this));
                symbol = Optional.empty();
            }
            return symbol;
        }).collect(List.collector());
    }

    @NotNull
    private Optional<Symbol.VarSymbol> retrieveParamSymbol(JCTree.JCMethodDecl methodDecl, Symbol.VarSymbol clauseParamSymbol) {
        Optional<Symbol.VarSymbol> symbol = methodDecl.sym.params().stream().filter(f -> f.name.equals(clauseParamSymbol.name)).findFirst();
        if (!symbol.isPresent()) {
            this.state.logError(methodDecl.pos(), JSickoDiagnostic.MissingParamName(clauseParamSymbol.name, this));
        }
        return symbol;
    }

    @NotNull
    private Optional<Symbol.VarSymbol> retrieveRaisesVarSymbol(JCTree.JCMethodDecl methodDecl, boolean checkUsage) {
        Optional<Symbol.VarSymbol> symbol;
        if (checkUsage && this.getConditionType().equals((Object)ContractConditionEnum.PRECONDITION)) {
            symbol = Optional.empty();
            this.state.logError(methodDecl.pos(), JSickoDiagnostic.RaisesOnPrecondition(this));
        } else {
            symbol = this.state.currentMethodRaisesVarDecl().map(varDecl -> varDecl.sym);
        }
        return symbol;
    }

    @NotNull
    private Optional<Symbol.VarSymbol> retrieveReturnsVarSymbol(JCTree.JCMethodDecl methodDecl, boolean checkUsage) {
        Optional<Symbol.VarSymbol> symbol;
        if (checkUsage && this.getConditionType().equals((Object)ContractConditionEnum.PRECONDITION)) {
            symbol = Optional.empty();
            this.state.logError(methodDecl.pos(), JSickoDiagnostic.ReturnsOnPrecondition(this));
        } else {
            symbol = this.state.currentMethodReturnVarDecl().map(s -> s.sym);
            if (!symbol.isPresent()) {
                this.state.logError(methodDecl.pos(), JSickoDiagnostic.ReturnsOnVoidMethod(this));
            }
        }
        return symbol;
    }

    private List<JCTree.JCStatement> createParamValuesStringExpression(JCTree.JCVariableDecl checkerVarDef, JCTree.JCIdent stringBuilderIdent, JCTree.JCMethodDecl methodDecl, List<JCTree.JCExpression> prefix) {
        Symbol.MethodSymbol clauseSymbol = this.resolvedMethodSymbol.get();
        List thisExpression = !methodDecl.sym.isStatic() ? List.of(this.factory.Literal("this: "), this.factory.This(methodDecl.sym.owner.type), this.factory.Literal(", ")) : List.nil();
        List resolvedVarSymbols = clauseSymbol.params().stream().map(clauseParamSymbol -> {
            String clauseParamName = clauseParamSymbol.name.toString();
            Optional<Symbol.VarSymbol> symbol = clauseParamName.equals("returns") ? this.retrieveReturnsVarSymbol(methodDecl, false) : (clauseParamName.equals("raises") ? this.retrieveRaisesVarSymbol(methodDecl, false) : this.retrieveParamSymbol(methodDecl, (Symbol.VarSymbol)clauseParamSymbol));
            return symbol;
        }).collect(List.collector());
        if (resolvedVarSymbols.stream().anyMatch(o -> o.isEmpty())) {
            return List.nil();
        }
        List args = resolvedVarSymbols.stream().map(Optional::get).flatMap(symbol -> {
            JCTree.JCIdent clauseParamIdent = this.factory.Ident((Symbol)symbol);
            clauseParamIdent.setType(symbol.type);
            clauseParamIdent.sym = symbol;
            return Stream.of(this.factory.Literal(symbol.name + ": "), clauseParamIdent, this.factory.Literal(", "));
        }).collect(List.collector()).prependList(thisExpression);
        List<JCTree.JCExpression> stringElems = args.prepend(this.factory.Literal("[")).take(args.size() > 1 ? args.size() : args.size() + 1).append(this.factory.Literal("]")).prependList(prefix);
        List<JCTree.JCExpression> reducedLiterals = ConditionClause.reduceStringLiterals(this.factory, stringElems);
        return reducedLiterals.stream().flatMap(elem -> {
            JCTree.JCExpression arg = elem;
            if (!elem.type.toString().equals(this.javac.stringType().toString())) {
                arg = elem.type instanceof Type.ArrayType ? this.javac.MethodInvocation(this.javac.javaBaseModule(), this.javac.Type(this.javac.retrieveType(this.javac.javaBaseModule(), "java.util.Arrays")), this.javac.Name("toString"), List.of(elem)) : this.javac.MethodInvocation(this.javac.javaBaseModule(), this.javac.Type(this.javac.stringType()), this.javac.Name("valueOf"), List.of(elem));
                JCTree.JCStatement disableChecker = this.javac.MethodCall(this.javac.unnamedModule(), this.factory.Ident(checkerVarDef), this.javac.Name("disableObjects"), List.of(elem));
                JCTree.JCStatement enableChecker = this.javac.MethodCall(this.javac.unnamedModule(), this.factory.Ident(checkerVarDef), this.javac.Name("enableObjects"), List.of(elem));
                JCTree.JCStatement append = this.javac.MethodCall(this.javac.javaBaseModule(), stringBuilderIdent, this.javac.Name("append"), List.of(arg));
                return Stream.of(disableChecker, append, enableChecker);
            }
            JCTree.JCStatement append = this.javac.MethodCall(this.javac.javaBaseModule(), stringBuilderIdent, this.javac.Name("append"), List.of(arg));
            return Stream.of(append);
        }).collect(List.collector());
    }

    private static List<JCTree.JCExpression> reduceStringLiterals(TreeMaker factory, List<JCTree.JCExpression> stringElems) {
        return stringElems.stream().reduce(List.nil(), (l, e) -> {
            if (l.isEmpty()) {
                return l.prepend(e);
            }
            JCTree.JCExpression head = (JCTree.JCExpression)l.head;
            if (head instanceof JCTree.JCLiteral && e instanceof JCTree.JCLiteral) {
                return l.tail.prepend(factory.Literal((String)((JCTree.JCLiteral)head).value + ((JCTree.JCLiteral)e).value));
            }
            return l.prepend(e);
        }, List::appendList).reverse();
    }

    List<JSickoDiagnostic.JSickoError> resolveContractMethod(JCTree.JCClassDecl classDecl) {
        Symbol.MethodSymbol resolvedMethod;
        Type classType = classDecl.sym.type;
        List<Type> closure = this.javac.typeClosure(classType);
        Optional optionalContractMethod = closure.stream().flatMap(closureElem -> closureElem.asElement().getEnclosedElements().stream().filter(contractElement -> contractElement.name.equals(this.methodName)).map(Symbol.MethodSymbol.class::cast)).findFirst();
        if (optionalContractMethod.isPresent() && (resolvedMethod = (Symbol.MethodSymbol)optionalContractMethod.get()).getReturnType() != null && !resolvedMethod.getReturnType().equals(this.javac.booleanType())) {
            return List.of(JSickoDiagnostic.ClauseIsNotBoolean(this, resolvedMethod));
        }
        if (optionalContractMethod.isEmpty()) {
            return List.of(JSickoDiagnostic.MissingClause(this));
        }
        this.resolvedMethodSymbol = optionalContractMethod;
        return List.nil();
    }

    public boolean isClauseMethodStatic() {
        if (!this.isResolved()) {
            throw new IllegalStateException("Contract method not resolved yet");
        }
        Symbol.MethodSymbol clauseMethod = this.resolvedMethodSymbol.get();
        return clauseMethod.getModifiers().contains((Object)Modifier.STATIC);
    }

    public String toString() {
        return this.conditionType + " " + this.clauseRep;
    }
}

