/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.codelounge.jsicko.plugin;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class OldValuesTable
implements Serializable {
    private final Deque<MethodScope> table = new ArrayDeque<MethodScope>();

    public void enter(String methodSignature) {
        MethodScope newScope = new MethodScope(methodSignature);
        this.table.push(newScope);
    }

    public void leave() {
        this.table.pop();
    }

    public synchronized Object getValue(String key) {
        return this.table.peek().get(key);
    }

    public synchronized void putValue(String key, Object value) {
        this.table.peek().put(key, value);
    }

    public boolean containsKey(String key) {
        return !this.table.isEmpty() && this.table.peek().containsKey(key);
    }

    private static class MethodScope
    implements Serializable {
        private final String methodSignature;
        private final transient Map<String, Object> scopeTable;

        private MethodScope() {
            this("<unknown>");
        }

        private MethodScope(String methodSignature) {
            this.methodSignature = methodSignature;
            this.scopeTable = new HashMap<String, Object>();
        }

        void put(String key, Object value) {
            this.scopeTable.put(key, value);
        }

        Object get(String key) {
            return this.scopeTable.get(key);
        }

        boolean containsKey(String key) {
            return this.scopeTable.containsKey(key);
        }
    }
}

