/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.codelounge.jsicko.plugin.diagnostics;

import ch.usi.si.codelounge.jsicko.plugin.ConditionClause;
import ch.usi.si.codelounge.jsicko.plugin.ContractConditionEnum;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.function.Function;

public abstract class JSickoDiagnostic {
    private static final Function<Boolean, String> staticRep = isStatic -> isStatic != false ? "static" : "non-static";

    private JSickoDiagnostic() {
    }

    public static JSickoError MissingClause(ConditionClause clause) {
        return new JSickoError("missing.clause", clause.getClauseRep());
    }

    public static JSickoError MissingParamName(Name paramName, ConditionClause clause) {
        return new JSickoError("missing.param.name", paramName.toString(), clause.getResolvedClauseRepWithNames());
    }

    public static JSickoError WrongParamType(Name paramName, Type expectedType, Type clauseType, ConditionClause clause) {
        return new JSickoError("wrong.param.type", paramName.toString(), String.valueOf(expectedType), String.valueOf(clauseType), clause.getResolvedClauseRepWithNames());
    }

    public static JSickoError ReturnsOnVoidMethod(ConditionClause clause) {
        return new JSickoError("returns.on.void.method", clause.getResolvedClauseRepWithNames());
    }

    public static JSickoError ReturnsOnPrecondition(ConditionClause clause) {
        return new JSickoError("returns.on.precondition", clause.getResolvedClauseRepWithNames());
    }

    public static JSickoError RaisesOnPrecondition(ConditionClause clause) {
        return new JSickoError("raises.on.precondition", clause.getResolvedClauseRepWithNames());
    }

    public static JSickoError InvariantHasNonZeroArity(JCTree.JCMethodDecl methodDeclMarkedAsInvariant) {
        return new JSickoError("invariant.non.zero.arity", methodDeclMarkedAsInvariant.getName().toString());
    }

    public static JSickoError InvariantIsStatic(JCTree.JCMethodDecl methodDeclMarkedAsInvariant) {
        return new JSickoError("invariant.is.static", methodDeclMarkedAsInvariant.getName().toString());
    }

    public static JSickoError InvariantIsNotBoolean(JCTree.JCMethodDecl methodDeclMarkedAsInvariant) {
        return new JSickoError("invariant.is.not.boolean", methodDeclMarkedAsInvariant.getName().toString(), String.valueOf(methodDeclMarkedAsInvariant.getReturnType()));
    }

    public static JSickoError ClauseIsNotBoolean(ConditionClause clause, Symbol.MethodSymbol methodSymbolMarkedAsClause) {
        return new JSickoError("clause.is.not.boolean", String.valueOf(clause), methodSymbolMarkedAsClause.name.toString(), String.valueOf(methodSymbolMarkedAsClause.getReturnType()));
    }

    public static JSickoError IncompatibleClause(ConditionClause clause, boolean isMethodStatic, Name methodName) {
        return new JSickoError("incompatible.clause", staticRep.apply(clause.isClauseMethodStatic()), String.valueOf(clause), staticRep.apply(isMethodStatic), String.valueOf(methodName));
    }

    public static JSickoNote InstrumentedMethodNote(JCTree.JCMethodDecl jcMethodDecl) {
        return new JSickoNote("instrumented.method", jcMethodDecl.sym.toString(), jcMethodDecl.toString());
    }

    public static JSickoNote InstrumentedClassNote(JCTree.JCClassDecl jcClassDecl) {
        return new JSickoNote("instrumented.class", jcClassDecl.sym.toString(), jcClassDecl.toString());
    }

    public static JSickoNote ContractInterfacesNote(Symbol.ClassSymbol sym, List<Type> contracts) {
        return new JSickoNote("contract.interfaces", sym.toString(), contracts.map(t -> t.toString()).toString(", "));
    }

    public static JSickoNote ConditionCheckNote(Symbol.MethodSymbol sym, ContractConditionEnum conditionType, List<List<ConditionClause>> groupedClauses) {
        return new JSickoNote("condition.checks", sym.toString(), conditionType.toString().toLowerCase(), groupedClauses.map(l -> l.map(c -> c.getMethodName()).toString(", ")).toString("; "));
    }

    public static JSickoNote OverriddenOldMethodNote(JCTree.JCMethodDecl overriddenOldMethod) {
        return new JSickoNote("overridden.old.method", overriddenOldMethod.toString());
    }

    public static class JSickoNote
    extends JSickoDiagnostic {
        private final JCDiagnostic.Note jcNote;

        JSickoNote(String key, Object ... args) {
            this.jcNote = new JCDiagnostic.Note("jsicko", key, args);
        }

        public JCDiagnostic.Note jcNote() {
            return this.jcNote;
        }
    }

    public static class JSickoWarning
    extends JSickoDiagnostic {
        private final JCDiagnostic.Warning jcWarning;

        JSickoWarning(String key, Object ... args) {
            this.jcWarning = new JCDiagnostic.Warning("jsicko", key, args);
        }

        public JCDiagnostic.Warning jcWarning() {
            return this.jcWarning;
        }
    }

    public static class JSickoError
    extends JSickoDiagnostic {
        private final JCDiagnostic.Error jcError;

        JSickoError(String key, Object ... args) {
            this.jcError = new JCDiagnostic.Error("jsicko", key, args);
        }

        public JCDiagnostic.Error jcError() {
            return this.jcError;
        }
    }
}

