/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.codelounge.jsicko.plugin.utils;

import ch.usi.si.codelounge.jsicko.Contract;
import ch.usi.si.codelounge.jsicko.plugin.ContractConditionEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ConditionChecker {
    private final Supplier<Optional<String>> dummy = Optional::empty;
    private final List<ConjunctConditionViolationSuppliers> conditionViolationSuppliersGroups;
    private final ContractConditionEnum contractConditionType;
    private final Function<String, Contract.ContractConditionViolation> violationSupplier;
    private static boolean enabled = true;
    private static final IdentityHashMap<Object, Boolean> disabledObjects = new IdentityHashMap();

    public static ConditionChecker newPreconditionChecker() {
        return new ConditionChecker(ContractConditionEnum.PRECONDITION);
    }

    public static ConditionChecker newPostconditionChecker() {
        return new ConditionChecker(ContractConditionEnum.POSTCONDITION);
    }

    public static ConditionChecker newInvariantChecker() {
        return new ConditionChecker(ContractConditionEnum.INVARIANT);
    }

    private ConditionChecker(ContractConditionEnum contractConditionType) {
        this.contractConditionType = contractConditionType;
        this.conditionViolationSuppliersGroups = new LinkedList<ConjunctConditionViolationSuppliers>();
        this.violationSupplier = contractConditionType.violationConstructor();
    }

    @SafeVarargs
    public final void addConditionGroup(Supplier<Optional<String>> ... conditionGroupViolationSuppliers) {
        this.conditionViolationSuppliersGroups.add(new ConjunctConditionViolationSuppliers(conditionGroupViolationSuppliers));
    }

    public static void universallyDisable() {
        enabled = false;
    }

    public static void universallyEnable() {
        enabled = true;
    }

    public static boolean isUniversallyEnabled() {
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableObjects(Object ... objects) {
        IdentityHashMap<Object, Boolean> identityHashMap = disabledObjects;
        synchronized (identityHashMap) {
            Arrays.stream(objects).forEach(object -> disabledObjects.put(object, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableObjects(Object ... objects) {
        IdentityHashMap<Object, Boolean> identityHashMap = disabledObjects;
        synchronized (identityHashMap) {
            Arrays.stream(objects).forEach(object -> disabledObjects.remove(object));
        }
    }

    public void check() throws Contract.ContractConditionViolation {
        this.check(null);
    }

    public void check(Object thisObject) throws Contract.ContractConditionViolation {
        if (!enabled || thisObject != null && disabledObjects.containsKey(thisObject)) {
            return;
        }
        List groupedViolations = this.conditionViolationSuppliersGroups.stream().map(ConjunctConditionViolationSuppliers::getFirstViolation).collect(Collectors.toList());
        boolean hasViolation = groupedViolations.stream().allMatch(Optional::isPresent);
        if (hasViolation) {
            List groupedViolationReps = groupedViolations.stream().flatMap(Optional::stream).collect(Collectors.toList());
            throw this.violationSupplier.apply(groupedViolationReps.toString());
        }
    }

    private static class ConjunctConditionViolationSuppliers {
        private final List<Supplier<Optional<String>>> conjunctSuppliers;

        ConjunctConditionViolationSuppliers(List<Supplier<Optional<String>>> conjunctSuppliers) {
            this.conjunctSuppliers = Collections.unmodifiableList(conjunctSuppliers);
        }

        @SafeVarargs
        ConjunctConditionViolationSuppliers(Supplier<Optional<String>> ... conjunctSuppliers) {
            this(Arrays.asList(conjunctSuppliers));
        }

        Optional<String> getFirstViolation() {
            return this.conjunctSuppliers.stream().flatMap(conditionElem -> ((Optional)conditionElem.get()).stream()).findFirst();
        }
    }
}

