/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.maven.plugin.git;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.api.Git;

abstract class GitSubmoduleMojo
extends AbstractMojo {
    @Parameter(defaultValue="false")
    boolean skip;
    @Parameter(defaultValue="false")
    boolean verbose;
    @Parameter(defaultValue="${project.basedir}/.git")
    File dotGitDirectory;

    GitSubmoduleMojo() {
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public final void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (this.skip) {
            if (this.verbose) {
                log.info((CharSequence)"Skipping execution of plugin.");
            }
            return;
        }
        if (!this.dotGitDirectory.exists()) {
            if (this.verbose) {
                log.info((CharSequence)("No .git directory found at: " + this.dotGitDirectory.getParent() + ". Skipping execution of plugin."));
            }
            return;
        }
        try (Git git = Git.open((File)this.dotGitDirectory);){
            this.execute(git);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    protected abstract void execute(Git var1) throws Exception;
}

