/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.maven.plugin.git;

import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleStatusType;

final class GitSubmoduleUtil {
    private GitSubmoduleUtil() {
    }

    static String describe(Repository repository, ObjectId target) throws GitAPIException, IOException {
        String result = Git.wrap((Repository)repository).describe().setTarget(target).setTags(true).call();
        String branch = repository.getBranch();
        boolean detached = ObjectId.isId((String)branch);
        String fallback = detached ? target.abbreviate(7).name() : "heads/" + branch;
        return result != null ? result : fallback;
    }

    static char getPrefix(SubmoduleStatusType type) {
        switch (type) {
            case INITIALIZED: {
                return ' ';
            }
            case UNINITIALIZED: {
                return '-';
            }
            case REV_CHECKED_OUT: {
                return '+';
            }
        }
        throw new IllegalStateException("Unexpected submodule status: " + type.name().toLowerCase());
    }

    static boolean hasConflicts(Repository repository) throws GitAPIException {
        if (repository == null) {
            return false;
        }
        return !Git.wrap((Repository)repository).status().call().getConflicting().isEmpty();
    }
}

