/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.maven.plugin.git;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;

final class RecursiveSubmoduleUpdater {
    private final Git git;
    private final Log log;
    private final Path root;

    RecursiveSubmoduleUpdater(Git git, Log log) {
        this.git = git;
        this.log = log;
        this.root = git.getRepository().getWorkTree().toPath().toAbsolutePath();
    }

    void update() throws GitAPIException, IOException {
        Repository repository = this.git.getRepository();
        this.git.submoduleInit().call();
        this.git.submoduleUpdate().call();
        this.update(repository);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update(Repository repository) throws GitAPIException, IOException {
        try (SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)repository);){
            while (walk.next()) {
                Repository submodule;
                block22: {
                    submodule = walk.getRepository();
                    Throwable throwable = null;
                    try {
                        Path absolute = submodule.getWorkTree().toPath().toAbsolutePath();
                        this.log.info((CharSequence)("Entering '" + this.root.relativize(absolute) + "'"));
                        Git git = Git.wrap((Repository)submodule);
                        git.submoduleInit().call();
                        git.submoduleUpdate().call();
                        this.update(submodule);
                        if (submodule == null) continue;
                        if (throwable == null) break block22;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (submodule == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    submodule.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            submodule.close();
                            throw throwable3;
                        }
                    }
                    try {
                        submodule.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                submodule.close();
            }
            return;
        }
    }
}

