/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.maven.plugin.git;

import ch.usi.si.seart.maven.plugin.git.GitSubmoduleUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleStatus;
import org.eclipse.jgit.submodule.SubmoduleStatusType;
import org.eclipse.jgit.submodule.SubmoduleWalk;

final class RecursiveSubmoduleStatusReporter {
    private final Git git;
    private final Log log;

    RecursiveSubmoduleStatusReporter(Git git, Log log) {
        this.git = git;
        this.log = log;
    }

    void status() throws GitAPIException, IOException {
        this.status("", this.git);
    }

    private void status(String parent, Git git) throws GitAPIException, IOException {
        Repository repository = git.getRepository();
        List statuses = git.submoduleStatus().call().values().stream().sorted(Comparator.comparing(SubmoduleStatus::getPath)).collect(Collectors.toList());
        for (SubmoduleStatus status : statuses) {
            String path = status.getPath();
            ObjectId head = status.getHeadId();
            ObjectId index = status.getIndexId();
            String sha = head != null ? head.getName() : index.getName();
            SubmoduleStatusType type = status.getType();
            Repository submodule = SubmoduleWalk.getSubmoduleRepository((Repository)repository, (String)path);
            Throwable throwable = null;
            try {
                Path relative = Paths.get(parent, path);
                boolean uninitialized = type == SubmoduleStatusType.UNINITIALIZED;
                String description = !uninitialized ? " (" + GitSubmoduleUtil.describe(submodule, head) + ")" : "";
                char prefix = GitSubmoduleUtil.hasConflicts(submodule) ? (char)'U' : (char)GitSubmoduleUtil.getPrefix(type);
                String message = String.format("%c%s %s%s", Character.valueOf(prefix), sha, relative, description);
                this.log.info((CharSequence)message);
                if (uninitialized) continue;
                this.status(path, Git.wrap((Repository)submodule));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (submodule == null) continue;
                if (throwable != null) {
                    try {
                        submodule.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                submodule.close();
            }
        }
    }
}

