/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.validation.constraints;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.Payload;

@Documented
@Constraint(validatedBy={})
@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Password {
    public Requirement[] requirements() default {Requirement.NUMBER, Requirement.LOWERCASE_LETTER, Requirement.UPPERCASE_LETTER};

    public int minLength() default 6;

    public int maxLength() default 0x7FFFFFFF;

    public String message() default "{ch.usi.si.seart.validation.constraints.Password.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static enum Requirement {
        NUMBER("\\d"),
        SYMBOL("[ !\"#$%&'()*+,-./:;<=>?@\\[\\]^_`{|}~]"),
        LOWERCASE_LETTER("[a-z]"),
        UPPERCASE_LETTER("[A-Z]");

        private final String charClass;

        private Requirement(String charClass) {
            this.charClass = charClass;
        }

        public String getRegexp() {
            return "(?=.*?" + this.charClass + ")";
        }
    }
}

